package com.antai.sport.http.server.team.training.leader.api.resolver;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.common.jwt.TokenService;
import com.antai.sport.http.server.repository.teamtraining.entity.TeamTrainingLeader;
import com.antai.sport.http.server.team.training.leader.api.annotation.LoginUser;
import com.antai.sport.http.server.team.training.leader.api.business.auth.mapper.AuthMapper;
import io.jsonwebtoken.Claims;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

import javax.annotation.Resource;

public class TeamTrainingLeaderArgumentResolver implements HandlerMethodArgumentResolver {

    @Value("${project.header-token-key}")
    private String headerTokenKey;
    @Value("${project.jwt.subject-key}")
    private String subjectKey;

    @Resource
    private AuthMapper authMapper;
    @Resource
    private TokenService tokenService;

    /**
     * 判断是否支持要转换的参数类型
     */
    @Override
    public boolean supportsParameter(MethodParameter methodParameter) {
        if (methodParameter.getParameterType().isAssignableFrom(TeamTrainingLeader.class)
                && methodParameter.hasParameterAnnotation(LoginUser.class)) {
            return true;
        }
        return false;
    }

    /**
     * 当支持后进行相应的转换 做业务操作
     */
    @Override
    public Object resolveArgument(MethodParameter methodParameter,
                                  ModelAndViewContainer modelAndViewContainer,
                                  NativeWebRequest request,
                                  WebDataBinderFactory webDataBinderFactory) throws Exception {
        //从请求头中获参数信息
        String token = request.getHeader(headerTokenKey);

        if (token == null || token.isEmpty()) {
            throw new BusinessException("token信息错误");
        }

        Claims claims = tokenService.validateToken(token);
        if (claims == null) {
            throw new BusinessException("token解析异常");
        }
        String username = claims.get(subjectKey).toString();
        TeamTrainingLeader sysUser = authMapper.getByUsername(username);

        if (sysUser == null) {
            throw new BusinessException("当前用户不存在");
        }

        return sysUser;

    }
}
