package com.antai.sport.http.server.team.training.leader.api.config;

import com.antai.sport.http.server.team.training.leader.api.interceptor.TokenInterceptor;
import com.antai.sport.http.server.team.training.leader.api.resolver.TeamTrainingLeaderArgumentResolver;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

/**
 * @Author liming
 * @Date 2021/8/22 17:03
 * @Email lmmax@126.com
 * @Description:
 */
@Configuration
@EnableTransactionManagement
@ConfigurationProperties(prefix = "project")
public class BaseConfig implements WebMvcConfigurer {

    private List<String> permitUrl;

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOriginPatterns("*").allowCredentials(true).allowedMethods("GET", "POST", "DELETE", "PUT", "OPTIONS").maxAge(3600);
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {

        registry.addInterceptor(tokenInterceptor()).addPathPatterns("/**").excludePathPatterns(permitUrl);
    }

    @Bean
    TokenInterceptor tokenInterceptor() {
        return new TokenInterceptor();
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(teamTrainingLeaderArgumentResolver());
    }

    @Bean
    TeamTrainingLeaderArgumentResolver teamTrainingLeaderArgumentResolver() {
        return new TeamTrainingLeaderArgumentResolver();
    }

    public void setPermitUrl(List<String> permitUrl) {
        this.permitUrl = permitUrl;
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        PaginationInnerInterceptor innerInterceptor = new PaginationInnerInterceptor();
        innerInterceptor.setDbType(DbType.MYSQL);
        innerInterceptor.setOverflow(true);
        interceptor.addInnerInterceptor(new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor(innerInterceptor);
        return interceptor;
    }

    @Bean
    public ConfigurationCustomizer configurationCustomizer() {
        return mybatisConfiguration -> mybatisConfiguration.setUseGeneratedShortKey(false);
    }

    @Bean("asyncTaskExecutor")
    public AsyncTaskExecutor asyncTaskExecutor() {
        ThreadPoolTaskExecutor asyncTaskExecutor = new ThreadPoolTaskExecutor();
        asyncTaskExecutor.setMaxPoolSize(50);
        asyncTaskExecutor.setCorePoolSize(20);
        asyncTaskExecutor.setThreadNamePrefix("异步线程-");
        asyncTaskExecutor.initialize();
        return asyncTaskExecutor;
    }
}
