package com.antai.sport.http.server.server.api.business.traininglog.mapper;

import com.antai.sport.http.server.repository.sport.entity.SportUserTrainingLog;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogSummaryVO;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogVO;
import com.antai.sport.http.server.server.api.business.traininglog.dto.TrainingDetailRankVO;
import com.antai.sport.http.server.server.api.business.traininglog.dto.TrainingDetailVO;
import com.antai.sport.http.server.server.api.business.user.dto.ScheduleResponseDTO;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

public interface SportUserTrainingLogBusinessMapper {
    SportUserTrainingLog getLongestTrainingLog(@Param("sportType") Integer sportType, @Param("userId") Long userId);

    SportUserTrainingLogSummaryVO getTrainingLogSummary(@Param("sportType") Integer sportType,
                                                        @Param("userId") Long userId,
                                                        @Param("beginDate") LocalDate beginDate,
                                                        @Param("endDate") LocalDate endDate);

    List<SportUserTrainingLogVO> getSportUserTrainingLog(@Param("userId") Long userId, @Param("date") LocalDate date, @Param("gameMode") Integer gameMod);

    List<ScheduleResponseDTO> getMonthTrainingSummary(@Param("playerId") Long playerId, @Param("beginDate") LocalDate beginDate, @Param("endDate") LocalDate endDate, @Param("today") LocalDate today);

    TrainingDetailVO getSportUserTrainingLogDetail(@Param("id") Long id);

    List<TrainingDetailRankVO> getRank(@Param("gameMode") Integer gameMode, @Param("sourceId") Long sourceId);
}
