package com.antai.sport.http.server.server.api.business.traininglog.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("用户训练记录详情")
public class TrainingDetailVO {
    @ApiModelProperty("运动类型 1:自行车 2:跑步")
    private Integer sportType;
    @ApiModelProperty("运动模式  10:漫游 20:日常赛 30:系列赛 40:课程训练 50: 团练 60:房间模式")
    private Integer gameMode;
    @ApiModelProperty("玩家id")
    private Long playerId;
    @ApiModelProperty("主数据id 如比赛为比赛id 房间模式为房间id 漫游为漫游记录id")
    private Long sourceId;
    @ApiModelProperty("源头名称")
    private String sourceName;
    @ApiModelProperty("运动记录Id")
    private Long recordId;
    @ApiModelProperty("地图名称")
    private String mapName;
    @ApiModelProperty("赛道名称")
    private String pathName;
    @ApiModelProperty("卡路里")
    private Integer calorie;
    @ApiModelProperty("点赞数量")
    private Integer praiseNum;
    @ApiModelProperty("比赛名次")
    private Integer matchRank;
    @ApiModelProperty("用时(秒)")
    private Integer duration;
    @ApiModelProperty("骑行总长度")
    private BigDecimal distance;
    @ApiModelProperty("爬坡高度")
    private BigDecimal climbDistance;
    @ApiModelProperty("平均功率")
    private BigDecimal avgFtp;
    @ApiModelProperty("平均速度")
    private BigDecimal avgSpeed;
    @ApiModelProperty("fit文件地址")
    private String fitUrl;
    @ApiModelProperty("记录时间 yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime createTime;
    @ApiModelProperty("模式: 10:竞速模式 2:道具模式")
    private Integer roomMode;
    @ApiModelProperty("圈数")
    private Integer cycles;
    @ApiModelProperty("活动总距离")
    private BigDecimal eventsDistance;
    @ApiModelProperty("活动总爬升高度")
    private BigDecimal eventsClimbDistance;
    @ApiModelProperty("获得积分")
    private Integer currency;

    @ApiModelProperty("体重")
    private BigDecimal weight;
    @ApiModelProperty("玩家当时ftp")
    private Integer ftp;
    @ApiModelProperty("玩家当时身高")
    private BigDecimal height;
    @ApiModelProperty("玩家当时设置最大心率")
    private Integer heartRate;
    @ApiModelProperty("玩家平均心率")
    private Integer avgHeartRate;
    @ApiModelProperty("1分钟平均最佳FTP")
    private BigDecimal oneMinutesFtp;
    @ApiModelProperty("5分钟平均最佳FTP")
    private BigDecimal fiveMinutesFtp;
    @ApiModelProperty("20分钟平均最佳FTP")
    private BigDecimal twentyMinutesFtp;
    @ApiModelProperty("1分钟平均最佳功体比")
    private BigDecimal oneMinutesWkg;
    @ApiModelProperty("5分钟平均最佳功体比")
    private BigDecimal fiveMinutesWkg;
    @ApiModelProperty("20分钟平均最佳功体比")
    private BigDecimal twentyMinutesWkg;
    @ApiModelProperty("得分")
    private BigDecimal score;
    @ApiModelProperty("比赛状态10:未完成比赛 20:完成比赛")
    private Integer status;
    @ApiModelProperty("系列赛id 如果记录为系列赛则不为空")
    private Long seriesId;
    @ApiModelProperty("性别1 男 2 女")
    private Integer sex;
    @ApiModelProperty("记录关联排名")
    List<TrainingDetailRankVO> rankList;
}
