package com.antai.sport.http.server.server.api.business.traininglog.converter;

import com.antai.sport.http.server.repository.sport.entity.SportUserMonthRank;
import com.antai.sport.http.server.repository.sport.entity.SportUserRank;
import com.antai.sport.http.server.repository.sport.entity.SportUserTrainingLog;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel = "spring")
public interface SportUserTrainingLogConverter {

    SportUserTrainingLog toSportUserTrainingLog(CyclingDataDTO source);

    @Mappings({
            @Mapping(source = "source.calorie", target = "totalCalorie"),
            @Mapping(source = "source.createTime", target = "updateTime"),
            @Mapping(source = "year", target = "year"),
            @Mapping(source = "month", target = "month")
    })
    SportUserMonthRank toSportUserMonthRank(SportUserTrainingLog source, Integer year, Integer month);

    @Mappings({
            @Mapping(source = "source.calorie", target = "totalCalorie"),
            @Mapping(source = "source.createTime", target = "updateTime"),
    })
    SportUserRank toSportUserRank(SportUserTrainingLog source);
}
