package com.antai.sport.http.server.server.api.business.tour.service;

import com.antai.sport.http.server.constants.GameMode;
import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.constants.TourRecordStatus;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.antai.sport.http.server.repository.tour.entity.TourRecord;
import com.antai.sport.http.server.repository.tour.mapper.TourRecordMapper;
import com.antai.sport.http.server.server.api.business.praise.service.PraiseService;
import com.antai.sport.http.server.server.api.business.tour.converter.TourRecordConverter;
import com.antai.sport.http.server.server.api.business.tour.dto.ReqTourRecordInit;
import com.antai.sport.http.server.server.api.business.tour.dto.RespTourRecordInit;
import com.antai.sport.http.server.server.api.business.traininglog.service.SportUserTrainingLogService;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class TourService {

    @Resource
    private TourRecordMapper tourRecordMapper;
    @Resource
    private SportUserMapper sportUserMapper;

    @Resource
    private TourRecordConverter tourRecordConverter;

    @Resource
    private PraiseService praiseService;
    @Resource
    private SportUserTrainingLogService sportUserTrainingLogService;

    /**
     * 初始化漫游记录
     *
     * @param initData
     * @return
     */
    public RespTourRecordInit init(ReqTourRecordInit initData) {
        RespTourRecordInit resp = new RespTourRecordInit();
        TourRecord tourRecord = new TourRecord();
        tourRecord.setPlayerId(initData.getPlayerId());
        tourRecord.setMap(initData.getMap());
        tourRecord.setPath(initData.getPath());
        tourRecord.setCreateTime(LocalDateTime.now());
        tourRecord.setStatus(TourRecordStatus.UNCOMMITTED);
        tourRecordMapper.insert(tourRecord);

        resp.setRecordId(tourRecord.getId());
        resp.setSportType(SportType.BICYCLE);
        resp.setGameMode(GameMode.TOUR);
        return resp;
    }

    /**
     * 上传漫游记录
     *
     * @param tourRecordList
     */
    @Transactional
    public void upload(List<CyclingDataDTO> tourRecordList) {
        tourRecordList.forEach(item -> {
            TourRecord oldRecord = tourRecordMapper.selectById(item.getRecordId());
            if (oldRecord != null && oldRecord.getStatus().equals(TourRecordStatus.UNCOMMITTED)) {
                SportUser user = sportUserMapper.selectById(oldRecord.getPlayerId());
                item.setWeight(user.getWeight());
                TourRecord tourRecord = tourRecordConverter.convertToTourRecord(item, TourRecordStatus.COMMITTED);
                tourRecord.setPraiseNum(praiseService.getPraiseByGameModeAndRecordId(GameMode.TOUR, item.getRecordId()));
                tourRecordMapper.updateById(tourRecord);

                //生成骑行日志
                sportUserTrainingLogService.createBicycleTrainingLog(oldRecord.getPlayerId(), GameMode.TOUR,
                        oldRecord.getId(), null, oldRecord.getMap(), oldRecord.getPath(), tourRecord.getPraiseNum(), item);
            }
        });
    }

}
