package com.antai.sport.http.server.server.api.business.teamtraining.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("团练列表对象")
public class TeamTrainingForListResponseDTO {
    @ApiModelProperty("团练id")
    public Long id;
    @ApiModelProperty("团长id")
    public Long leaderId;
    @ApiModelProperty("团长绑定玩家id")
    public Long leaderPlayerId;
    @ApiModelProperty("团长姓名")
    public String leaderName;
    @ApiModelProperty("头像")
    private String avatar;
    @ApiModelProperty("训练时长(分钟)")
    public Integer trainingMinute;
    @ApiModelProperty("团练名称")
    public String name;
    @ApiModelProperty("列表展示时间 yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    public LocalDateTime showTime;
    @ApiModelProperty("地图")
    private String map;
    @ApiModelProperty("赛道")
    private String path;
    @ApiModelProperty("允许进入时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime entryTime;
    @ApiModelProperty("开始比赛时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;
    @ApiModelProperty("比赛结束时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;
    @ApiModelProperty("长度")
    public BigDecimal distance;
    @ApiModelProperty("爬坡高度")
    public BigDecimal climbDistance;
    @ApiModelProperty("报名人数")
    public Integer registeredNum;
    @ApiModelProperty("是否已报名，只有当按用户查询时有效")
    public Boolean registered;
}
