package com.antai.sport.http.server.server.api.business.series.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("系列赛比赛VO")
public class SeriesMatchForGameServerVO {
    @ApiModelProperty("比赛id")
    public Long id;
    @ApiModelProperty("比赛名称")
    public String name;
    @ApiModelProperty("地图")
    private String map;
    @ApiModelProperty("赛道")
    private String path;
    @ApiModelProperty("类型 10 预选赛 20 淘汰赛")
    private Integer type;
    @ApiModelProperty("允许进入时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime entryTime;
    @ApiModelProperty("开始比赛时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;
    @ApiModelProperty("比赛结束时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime endTime;
    @ApiModelProperty("长度")
    private BigDecimal distance;
    @ApiModelProperty("爬坡高度")
    private BigDecimal climbDistance;
    @ApiModelProperty("赛事描述")
    private String description;
}
