package com.antai.sport.http.server.server.api.business.series.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel("系列赛列表对象")
@Data
public class SeriesListVO {
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("名称")
    private String name;
    @ApiModelProperty("封面图片地址")
    private String imgUrl;
    @ApiModelProperty("报名人数")
    private String applyNum;
    @ApiModelProperty("状态 10 报名中 20 进行中 30 未开赛 40 已完赛")
    private Integer status;
    @ApiModelProperty("报名开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime applyStartTime;
    @ApiModelProperty("报名结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime applyEndTime;

}
