package com.antai.sport.http.server.server.api.business.series.mapper;

import com.antai.sport.http.server.repository.series.entity.SeriesApply;
import com.antai.sport.http.server.server.api.business.series.dto.SeriesQualifyingMatchRankDTO;
import com.antai.sport.http.server.server.api.business.series.vo.*;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

public interface SeriesBusinessMapper {

    List<SeriesListVO> getSeriesList(@Param("name") String name);

    List<SeriesNoticeVO> getSeriesNotice(@Param("seriesId") Long seriesId);

    List<SeriesRoundVO> getSeriesRound(@Param("seriesId") Long seriesId);

    Boolean checkExistUserSeriesApply(@Param("seriesId") Long seriesId, @Param("sportUserId") Long sportUserId);

    List<SeriesAreaVO> getSeriesAreaList(@Param("seriesId") Long seriesId);

    SeriesApply getLatestUserSeriesApplyInfo(@Param("sportUserId") Long sportUserId);

    Integer getBestResult(@Param("roundId") Long roundId, @Param("sportUserId") Long sportUserId);

    Integer getSeriesQualifyingMatchLeftChance(@Param("roundId") Long roundId, @Param("sportUserId") Long sportUserId);

    SeriesApply getSeriesApply(@Param("seriesId") Long seriesId, @Param("sportUserId") Long sportUserId);

    List<SeriesQualifyingMatchVO> getSeriesQualifyingMatchList(@Param("roundId") Long roundId,
                                                               @Param("areaId") Long areaId,
                                                               @Param("sportUserId") Long sportUserId,
                                                               @Param("today") LocalDate today,
                                                               @Param("tomorrow") LocalDate tomorrow);

    Integer getMySeriesQualifyingMatchRank(@Param("roundId") Long roundId,
                                           @Param("areaId") Long areaId,
                                           @Param("duration") Integer duration,
                                           @Param("createTime") LocalDateTime createTime);

    IPage<SeriesQualifyingMatchRankVO> getSeriesQualifyingMatchRank(IPage<SeriesQualifyingMatchRankVO> page,
                                                                    @Param("param") SeriesQualifyingMatchRankDTO param);

    SeriesKnockoutMatchListVO getUserSeriesKnockoutMatch(@Param("roundId") Long roundId,
                                                         @Param("sportUserId") Long sportUserId);

    List<SeriesKnockoutMatchListVO> getOtherSeriesKnockoutMatchList(@Param("roundId") Long roundId,
                                                                    @Param("sportUserId") Long sportUserId);

    IPage<SeriesKnockoutMatchUserVO> getSeriesKnockoutMatchUserList(IPage<SeriesKnockoutMatchUserVO> page,
                                                                    @Param("roundId") Long roundId,
                                                                    @Param("matchId") Long matchId);

    IPage<SeriesKnockoutMatchRankVO> getSeriesKnockoutMatchRankList(IPage<SeriesKnockoutMatchRankVO> page,
                                                                    @Param("matchId") Long matchId);

    List<SeriesForGameServerVO> getSeriesForGameServer();

    List<SeriesMatchForGameServerVO> getSeriesMatchForGameServer(@Param("now") LocalDateTime now);

    List<SeriesMatchResultTopVO> getSeriesMatchResult(@Param("seriesId") Long seriesId);

    List<SeriesMatchResultVO> getFinalRoundMatchList(@Param("seriesId") Long seriesId,
                                                     @Param("sportUserId") Long sportUserId);
}
