package com.antai.sport.http.server.server.api.business.series.converter;

import com.antai.sport.http.server.repository.series.entity.Series;
import com.antai.sport.http.server.repository.series.entity.SeriesApply;
import com.antai.sport.http.server.repository.series.entity.SeriesMatchPlayerRecord;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.server.api.business.series.dto.SeriesApplyDTO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesApplyPreLoadVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesDetailsVO;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(componentModel = "spring")
public interface SeriesConverter {
    @Mapping(source = "status", target = "status")
    SeriesDetailsVO toSeriesDetailVO(Series series, Integer status);

    SeriesApplyPreLoadVO toSeriesApplyPreLoadVO(SportUser sportUser);

    SeriesApply toSeriesApply(SeriesApplyDTO source);

    @Mapping(source = "source.recordId", target = "id")
    @Mapping(source = "finished", target = "finished")
    SeriesMatchPlayerRecord toSeriesMatchPlayerRecord(CyclingDataDTO source, Boolean finished);
}
