package com.antai.sport.http.server.server.api.business.roommode.conroller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.roommode.dto.ReqRoomInit;
import com.antai.sport.http.server.server.api.business.roommode.dto.RespRoomInit;
import com.antai.sport.http.server.server.api.business.roommode.dto.RespRoomRank;
import com.antai.sport.http.server.server.api.business.roommode.service.RoomModeService;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("/room/mode")
@RestController
@Api(tags = {"房间模式"})
public class RoomModeController {

    @Resource
    private RoomModeService roomModeService;

    @ApiOperation(value = "初始化房间")
    @PostMapping("/init")
    public ResponseEntity<Result<RespRoomInit>> init(@RequestBody ReqRoomInit initParam) {
        return success(roomModeService.init(initParam));
    }

    @ApiOperation("记录上传")
    @PostMapping("/record/upload")
    public ResponseEntity<Result> upload(@RequestBody List<CyclingDataDTO> dataList) {
        roomModeService.upload(dataList);
        return success();
    }

    @ApiOperation("关闭房间")
    @GetMapping("/close/{roomId}")
    public ResponseEntity<Result> closeRoom(@PathVariable("roomId") Long roomId) {
        roomModeService.closeRoom(roomId);
        return success();
    }

    @ApiOperation("查看排名")
    @GetMapping("/rank/{roomId}")
    public ResponseEntity<Result<List<RespRoomRank>>> rank(@PathVariable("roomId") Long roomId) {
        return success(roomModeService.rank(roomId));
    }
}
