package com.antai.sport.http.server.server.api.business.props.service;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.constants.GameCurrencyLogType;
import com.antai.sport.http.server.constants.GameCurrencySourceType;
import com.antai.sport.http.server.repository.shop.entity.*;
import com.antai.sport.http.server.repository.shop.mapper.*;
import com.antai.sport.http.server.server.api.business.props.mapper.PropsBizMapper;
import com.antai.sport.http.server.server.api.business.props.vo.UserPropsItemVO;
import com.antai.sport.http.server.server.api.business.props.vo.UserPropsVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class PropsService {

    @Resource
    private PropsBizMapper propsBizMapper;
    @Resource
    private SportUserPropsMapper sportUserPropsMapper;
    @Resource
    private PropsMapper propsMapper;
    @Resource
    private SportUserPropsOrderMapper sportUserPropsOrderMapper;
    @Resource
    private SportUserGameCurrencyMapper sportUserGameCurrencyMapper;
    @Resource
    private SportUserGameCurrencyLogMapper sportUserGameCurrencyLogMapper;

    public UserPropsVO getUserProps(Long sportUserId) {
        UserPropsVO result = new UserPropsVO();
        Map<String, List<UserPropsItemVO>> propsItemMap = new HashMap<>();
        List<UserPropsItemVO> propsItemList = propsBizMapper.getUserProps(sportUserId);
        for (UserPropsItemVO propsItem : propsItemList) {
            if (!propsItemMap.containsKey(propsItem.getPart())) {
                propsItemMap.put(propsItem.getPart(), new ArrayList<>());
            }
            propsItemMap.get(propsItem.getPart()).add(propsItem);
        }
        result.setProps(propsItemMap);
        return result;
    }

    @Transactional
    public void purchase(Long sportUserId, Long propsId) {
        QueryWrapper<SportUserProps> userPropsQuery = new QueryWrapper<>();
        userPropsQuery.lambda().eq(SportUserProps::getSportUserId, sportUserId).eq(SportUserProps::getPropsId, propsId);
        SportUserProps userProps = sportUserPropsMapper.selectOne(userPropsQuery);
        if (userProps != null) {
            throw new BusinessException("您已经购买过当前装备，不能重复购买");
        }
        Props props = propsMapper.selectById(propsId);
        QueryWrapper<SportUserGameCurrency> userGameCurrencyQuery = new QueryWrapper<>();
        userGameCurrencyQuery.lambda().eq(SportUserGameCurrency::getSportUserId, sportUserId);
        SportUserGameCurrency userGameCurrency = sportUserGameCurrencyMapper.selectOne(userGameCurrencyQuery);
        if (userGameCurrency == null || userGameCurrency.getAmmount() < props.getPrice()) {
            throw new BusinessException("对不起，您的余额不足");
        }


        SportUserPropsOrder order = new SportUserPropsOrder();
        order.setPrice(props.getPrice());
        order.setPropsId(propsId);
        order.setSportUserId(sportUserId);
        order.setCtDate(LocalDateTime.now());
        sportUserPropsOrderMapper.insert(order);

        userProps = new SportUserProps();
        userProps.setPropsId(propsId);
        userProps.setPropsOrderId(order.getId());
        userProps.setSportUserId(sportUserId);
        userProps.setCtDate(LocalDateTime.now());
        sportUserPropsMapper.insert(userProps);

        //处理积分操作
        userGameCurrency.setAmmount(userGameCurrency.getAmmount() - props.getPrice());
        sportUserGameCurrencyMapper.updateById(userGameCurrency);

        String description = "购买装备：" + props.getName();
        SportUserGameCurrencyLog userGameCurrencyLog = new SportUserGameCurrencyLog();
        userGameCurrencyLog.setSourceType(GameCurrencySourceType.SHOP);
        userGameCurrencyLog.setType(GameCurrencyLogType.SUBTRACT);
        userGameCurrencyLog.setSportUserId(sportUserId);
        userGameCurrencyLog.setAmmount(props.getPrice());
        userGameCurrencyLog.setSourceId(order.getId());
        userGameCurrencyLog.setCtDate(LocalDateTime.now());
        userGameCurrencyLog.setDescription(description);
        sportUserGameCurrencyLogMapper.insert(userGameCurrencyLog);

    }
}
