package com.antai.sport.http.server.server.api.business.club.converter;

import com.antai.sport.http.server.repository.club.entity.Club;
import com.antai.sport.http.server.repository.club.entity.ClubNotice;
import com.antai.sport.http.server.server.api.business.club.dto.CreateClubNoticeDTO;
import com.antai.sport.http.server.server.api.business.club.dto.CreateClubReqDTO;
import com.antai.sport.http.server.server.api.business.club.dto.UpdateClubNoticeDTO;
import com.antai.sport.http.server.server.api.business.club.dto.UpdateClubReqDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.time.LocalDateTime;

@Mapper(componentModel = "spring")
public interface ClubConverter {

    @Mapping(target = "chairmanId", source = "source.createUser")
    @Mapping(target = "createTime", source = "now")
    @Mapping(target = "updateTime", source = "now")
    @Mapping(target = "totalClimbDistance", constant = "0")
    @Mapping(target = "totalDistance", constant = "0")
    @Mapping(target = "totalDuration", constant = "0")
    @Mapping(target = "totalCalorie", constant = "0")
    @Mapping(target = "memberNumber", constant = "1")
    Club createDTOtoClub(CreateClubReqDTO source, LocalDateTime now);

    @Mapping(target = "updateTime", source = "now")
    Club updateDTOtoClub(UpdateClubReqDTO source, LocalDateTime now);

    @Mapping(target = "createTime", source = "now")
    @Mapping(target = "updateTime", source = "now")
    @Mapping(target = "deleted", constant = "0")
    ClubNotice createClubNoticeDTOToClubNotice(CreateClubNoticeDTO source, LocalDateTime now);

    @Mapping(target = "updateTime", source = "now")
    ClubNotice updateClubNoticeDTOToClubNotice(UpdateClubNoticeDTO source, LocalDateTime now);
}
