package com.antai.sport.http.server.server.api.business.achievement.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("成就主页单项成就数据")
public class AchievementHomeItemVO {
    @ApiModelProperty("成就名称")
    private String achievementName;
    @ApiModelProperty("logo url")
    private String logo;
    @ApiModelProperty("成就说明")
    private String remark;
    @ApiModelProperty("获得成就时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime createTime;
    @ApiModelProperty("百分比(精确到小数点后两位)")
    private BigDecimal percent;
    @ApiModelProperty("是否已获得 true:已获得 false:未获得")
    private Boolean awarded;
}
