package com.antai.sport.http.server.repository.sport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户选装外观
 * </p>
 *
 * @author liming
 * @since 2021-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SportUserSectionSkin implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户id
     */
    private Long sportUserId;

    /**
     * 类型 1.身体部位 2.设备
     */
    private Integer type;

    /**
     * 部位
     */
    private Long section;

    /**
     * 部位key
     */
    private String sectionKey;

    /**
     * 皮肤
     */
    private Long skin;

    /**
     * 皮肤key
     */
    private String skinKey;

    /**
     * 删除标记
     */
    @TableLogic
    private Integer deleted;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;


}
