package com.antai.sport.http.server.repository.sport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-03-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SportUserFriendRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 发起人
     */
    private Long sportUserId;

    /**
     * 目标用户id
     */
    private Long targetUserId;

    /**
     * 状态 10:待接收 20:已接受 30:已拒绝
     */
    private Integer status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 最后修改人
     */
    private Integer lmUserId;

    /**
     * 最后修改时间
     */
    private LocalDateTime lmDate;


}
