package com.antai.sport.http.server.repository.series.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-09-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class Series implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 系列赛名称
     */
    private String name;

    /**
     * 封面图片地址
     */
    private String imgUrl;

    /**
     * 报名开始时间
     */
    private LocalDateTime applyStartTime;

    /**
     * 报名结束时间
     */
    private LocalDateTime applyEndTime;

    /**
     * 报名数量
     */
    private Integer applyNum;

    /**
     * 描述
     */
    private String description;

    /**
     * 比赛协议
     */
    private String agreement;

    /**
     * 状态 10 未发布 20 已发布
     */
    private Integer status;

    /**
     * 比赛是否已完结
     */
    private Boolean finished;

    /**
     * 显示顺序
     */
    private Integer showOrder;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
