package com.antai.sport.http.server.repository.base.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 行政单位管理
 * </p>
 *
 * @author liming
 * @since 2021-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class BaseArea implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 行政单位编码
     */
    private String code;

    /**
     * 行政单位名称
     */
    private String name;

    /**
     * 父节点id
     */
    private Long parentId;

    /**
     * 处于第几层
     */
    private Integer level;

    /**
     * 是否叶子节点
     */
    private Boolean leaf;

    /**
     * ID全路径
     */
    private String idPath;

    /**
     * 名称全路径
     */
    private String namePath;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 创建人
     */
    private Long ctUserId;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 最后修改人
     */
    private Long lmUserId;

    /**
     * 最后修改时间
     */
    private LocalDateTime lmDate;


}
