package com.antai.sport.http.server.mobile.api.business.sport.user;

import com.antai.sport.http.server.mobile.api.business.sport.user.dto.*;
import com.antai.sport.http.server.common.annotation.LoginSportUser;
import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

/**
 * @Author liming
 * @Date 2021/8/21 19:41
 * @Email lmmax@126.com
 * @Description:
 */
@RestController
@Api(tags = {"用户相关接口"})
public class SportUserController {

    @Resource
    private SportUserService sportUserService;

    @ApiOperation(value = "登录接口", notes = "登录成功后返回长短token,data为用户id")
    @PostMapping("/login")
    public ResponseEntity<Result> login(@RequestBody ReqLogin param) {
        return success(sportUserService.login(param));
    }

    @ApiOperation(value = "获取登录短信验证码", notes = "非生产环境中data直接返回验证码，可以直接用于注册，不会发送短信消息")
    @GetMapping("/login/sms/captcha/{phone}")
    public ResponseEntity<Result<String>> sendLoginSmsCaptcha(@PathVariable String phone) {
        return success(sportUserService.sendLoginSmsCaptcha(phone));
    }

    @ApiOperation(value = "用户基本信息编辑页面所需基础数据")
    @GetMapping("/user/info/init")
    public ResponseEntity<Result<RespRegisterInfo>> getUserInitInfo() {
        return success(sportUserService.getRegisterInfo());
    }

    @ApiOperation(value = "用户基本信息保存")
    @PostMapping("/user/info")
    public ResponseEntity<Result> saveUserInfo(@LoginSportUser SportUser loginUser, @RequestBody ReqSaveUserInfo param) {
        sportUserService.saveUserInfo(loginUser, param);
        return success();
    }

    @ApiOperation(value = "用户基本信息获取")
    @GetMapping("/user/info")
    public ResponseEntity<Result<RespBaseUserInfo>> getUserInfo(@LoginSportUser SportUser loginUser) {
        return success(sportUserService.getUserInfo(loginUser));
    }

    @ApiOperation(value = "用户皮肤获取", notes = "返回data中为map:其中key是部位key，value是皮肤key")
    @GetMapping("/user/skin")
    public ResponseEntity<Result<Map<String, String>>> getUserSkin(@LoginSportUser SportUser loginUser) {
        return success(sportUserService.getUserSkin(loginUser));
    }

    @ApiOperation(value = "用户皮肤保存")
    @PostMapping("/user/skin")
    public ResponseEntity<Result> saveUserSkin(@LoginSportUser SportUser loginUser, @RequestBody List<ReqSaveUserSkin> param) {
        sportUserService.saveUserSkin(loginUser, param);
        return success();
    }

    @ApiOperation(value = "根据id批量查询用户信息",notes = "body传入id数组")
    @PostMapping("/users/info")
    public ResponseEntity<Result<List<RespUserInfo>>> getUserInfoByIds(@RequestBody List<Long> ids) {
        return success(sportUserService.getUserInfoByIds(ids));
    }

    @ApiOperation(value = "模糊查询查询用户信息",notes = "body传入姓名或手机号")
    @PostMapping("/users/info/like")
    public ResponseEntity<Result<List<RespUserInfo>>> getUserInfoLike(@RequestBody String key) {
        return success(sportUserService.getUserInfoLike(key));
    }
}
