package com.antai.sport.http.server.management.api.interceptor;

import com.antai.sport.http.server.common.jwt.TokenService;
import io.jsonwebtoken.Claims;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static org.springframework.http.HttpStatus.UNAUTHORIZED;

public class TokenInterceptor implements HandlerInterceptor {

    @Value("${project.header-token-key}")
    private String headerTokenKey;

    @Resource
    private TokenService tokenService;

    @Override
    public boolean preHandle(HttpServletRequest request,
                             HttpServletResponse response, Object handler) throws Exception {

        String token = request.getHeader(headerTokenKey);
        if (request.getMethod().equals(RequestMethod.OPTIONS.name())) {
            response.setStatus(HttpStatus.OK.value());
            return true;
        }
        if (null == token) {
            response.sendError(HttpServletResponse.SC_UNAUTHORIZED, UNAUTHORIZED.getReasonPhrase());
            return false;
        }

        Claims claims = tokenService.validateToken(token);
        if (claims == null) {
            response.sendError(HttpServletResponse.SC_UNAUTHORIZED, UNAUTHORIZED.getReasonPhrase());
            return false;
        }

        return true;
    }

}
