package com.antai.sport.http.server.management.api.business.simplematch.service;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.management.api.business.simplematch.converter.SimpleMatchConverter;
import com.antai.sport.http.server.management.api.business.simplematch.dto.SimpleMatchListRequestDTO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.SimpleMatchListResponseDTO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.SimpleMatchResponseDTO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.vo.MapPathVO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.vo.SimpleMatchListVO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.vo.SimpleMatchVO;
import com.antai.sport.http.server.management.api.business.simplematch.mapper.SimpleMatchBusinessMapper;
import com.antai.sport.http.server.repository.map.entity.Map;
import com.antai.sport.http.server.repository.map.entity.MapPath;
import com.antai.sport.http.server.repository.map.mapper.MapMapper;
import com.antai.sport.http.server.repository.map.mapper.MapPathMapper;
import com.antai.sport.http.server.repository.simplematch.entity.SimpleMatch;
import com.antai.sport.http.server.repository.simplematch.mapper.SimpleMatchMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service
public class SimpleMatchService {
    @Resource
    private SimpleMatchMapper simpleMatchMapper;
    @Resource
    private SimpleMatchBusinessMapper simpleMatchBusinessMapper;
    @Resource
    private MapMapper mapMapper;
    @Resource
    private MapPathMapper mapPathMapper;
    @Resource
    private SimpleMatchConverter simpleMatchConverter;
    @Resource
    private SimpleMatchChangeNotifyService simpleMatchChangeNotifyService;

    public SimpleMatchListResponseDTO getMatchList(SimpleMatchListRequestDTO param) {
        Page<SimpleMatchListVO> pageParam = new Page<>(param.getPageNo(), param.getPageSize());
        if (StringUtils.isNotEmpty(param.getSortOrder())) {
            pageParam.addOrder(new OrderItem("start_time", "asc".equals(param.getSortOrder())));
        }
        pageParam.addOrder(new OrderItem("id", false));
        IPage<SimpleMatchListVO> result = simpleMatchBusinessMapper.getMatchList(pageParam, param);

        SimpleMatchListResponseDTO dto = new SimpleMatchListResponseDTO();
        dto.setData(result.getRecords());
        dto.setPageNo(param.getPageNo());
        dto.setTotalCount(result.getTotal());
        return dto;
    }

    public void deleteMatch(Long matchId) {
        SimpleMatch simpleMatch = simpleMatchMapper.selectById(matchId);
        if (simpleMatch.getStatus() != null && simpleMatch.getStatus().equals(20)) {
            throw new BusinessException("已发布比赛不能删除");
        }
        simpleMatch.setDeleted(Integer.valueOf(DeleteStatus.DELETED));
        simpleMatchMapper.updateById(simpleMatch);
    }

    public void publish(Long matchId) {
        SimpleMatch simpleMatch = simpleMatchMapper.selectById(matchId);
        if (simpleMatch.getStatus() == null || simpleMatch.getStatus().equals(10)) {
            simpleMatch.setStatus(20);
        } else {
            simpleMatch.setStatus(10);
        }
        simpleMatchMapper.updateById(simpleMatch);
        simpleMatchChangeNotifyService.notifyGameServerSimpleMatchChange();
    }

    public SimpleMatchResponseDTO getSimpleMatch(Long matchId) {
        SimpleMatchResponseDTO result = new SimpleMatchResponseDTO();
        SimpleMatch simpleMatch;
        if (matchId == null || matchId == 0) {
            simpleMatch = new SimpleMatch();
            simpleMatch.setStatus(10);
        } else {
            simpleMatch = simpleMatchMapper.selectById(matchId);
            if (simpleMatch == null) {
                throw new BusinessException("您查询的比赛不存在");
            }
        }
        SimpleMatchVO simpleMatchVO = simpleMatchConverter.toSimpleMatchVO(simpleMatch);
        result.setSimpleMatch(simpleMatchVO);
        List<Map> mapList = mapMapper.selectList(null);
        List<MapPath> mapPathList = mapPathMapper.selectList(null);
        HashMap<String, MapPathVO> mapPathVOHashMap = new HashMap<>();
        List<MapPathVO> mapPathVOList = new ArrayList<>(mapList.size());
        mapList.forEach(item -> {
            MapPathVO mapVO = new MapPathVO();
            mapVO.setId(item.getId());
            mapVO.setKey(item.getMapKey());
            mapVO.setName(item.getMapName());
            mapVO.setPathList(new ArrayList<>());
            mapPathVOList.add(mapVO);
            mapPathVOHashMap.put(item.getMapKey(), mapVO);
        });
        mapPathList.forEach(item -> {
            MapPathVO mapPathVO = new MapPathVO();
            mapPathVO.setId(item.getId());
            mapPathVO.setKey(item.getPathKey());
            mapPathVO.setName(item.getPathName());
            if (mapPathVOHashMap.containsKey(item.getMapKey())) {
                mapPathVOHashMap.get(item.getMapKey()).getPathList().add(mapPathVO);
            }
        });
        result.setMapList(mapPathVOList);
        return result;
    }

    public void save(SimpleMatchVO simpleMatchVO) {
        SimpleMatch simpleMatch = simpleMatchConverter.toSimpleMatch(simpleMatchVO);
        if (simpleMatch.getId() != null && simpleMatch.getId() > 0) {
            simpleMatchMapper.updateById(simpleMatch);
        } else {
            simpleMatch.setStatus(10);
            simpleMatchMapper.insert(simpleMatch);
        }
        simpleMatchChangeNotifyService.notifyGameServerSimpleMatchChange();
    }

}
