package com.antai.sport.http.server.management.api.business.series.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.management.api.annotation.LoginUser;
import com.antai.sport.http.server.management.api.business.series.dto.*;
import com.antai.sport.http.server.management.api.business.series.service.SeriesService;
import com.antai.sport.http.server.management.api.business.series.vo.*;
import com.antai.sport.http.server.repository.series.entity.Series;
import com.antai.sport.http.server.repository.sys.entity.SysUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("/series")
@Api(tags = {"系列赛"})
public class SeriesController {

    @Resource
    private SeriesService seriesService;

    /**
     * 加载系列赛列表
     *
     * @param dto
     * @return
     */
    @PostMapping("list")
    @ApiOperation("列表")
    public ResponseEntity<Result<SeriesListPageVO>> getSeriesList(@RequestBody SeriesListQueryDTO dto) {
        return success(seriesService.getSeriesList(dto));
    }

    @GetMapping("{id}")
    @ApiOperation("明细")
    public ResponseEntity<Result<Series>> getSeries(@PathVariable("id") Long id) {
        return success(seriesService.getSeries(id));
    }

    @PostMapping
    public ResponseEntity<Result> saveSeries(@RequestBody SeriesSaveDTO series, @LoginUser SysUser loginUser) {
        seriesService.saveSeries(series, loginUser);
        return success();
    }

    @PutMapping("publish/{id}")
    public ResponseEntity<Result> publishSeries(@PathVariable("id") Long id) {
        seriesService.publishSeries(id);
        return success();
    }

    @PutMapping("finished/{id}")
    public ResponseEntity<Result> finishedSeries(@PathVariable("id") Long id) {
        seriesService.finishedSeries(id);
        return success();
    }

    @DeleteMapping("{id}")
    public ResponseEntity<Result> deletedSeries(@PathVariable("id") Long id) {
        seriesService.deletedSeries(id);
        return success();
    }

    @GetMapping("area/{seriesId}")
    public ResponseEntity<Result<List<SeriesAreaDTO>>> getSeriesAreaList(@PathVariable("seriesId") Long seriesId) {
        return success(seriesService.getSeriesAreaList(seriesId));
    }

    @PostMapping("area")
    public ResponseEntity<Result> saveSeriesArea(@RequestBody SeriesAreaSaveDTO dto) {
        seriesService.saveSeriesArea(dto);
        return success();
    }

    @GetMapping("round/{roundId}")
    public ResponseEntity<Result<SeriesRoundDetailVO>> getSeriesRoundDetail(@PathVariable("roundId") Long roundId) {
        return success(seriesService.getSeriesRoundDetail(roundId));
    }

    @PostMapping("round")
    public ResponseEntity<Result> saveSeriesRound(@RequestBody SeriesRoundSaveDTO dto) {
        seriesService.saveSeriesRound(dto);
        return success();
    }

    @GetMapping("round/list/{seriesId}")
    public ResponseEntity<Result<List<SeriesRoundListVO>>> getRoundListBySeriesId(@PathVariable("seriesId") Long seriesId) {
        return success(seriesService.getRoundListBySeriesId(seriesId));
    }

    @DeleteMapping("round/{roundId}")
    public ResponseEntity<Result> deleteRound(@PathVariable("roundId") Long roundId) {
        seriesService.deleteRound(roundId);
        return success();
    }

    @PutMapping("round/{roundId}")
    public ResponseEntity<Result> changeRoundStatus(@PathVariable("roundId") Long roundId) {
        seriesService.changeRoundStatus(roundId);
        return success();
    }

    @GetMapping("round/match/{roundId}")
    public ResponseEntity<Result<List<SeriesMatchListVO>>> getMatchByRoundId(@PathVariable("roundId") Long roundId) {
        return success(seriesService.getMatchByRoundId(roundId));
    }

    @DeleteMapping("round/match/{matchId}")
    public ResponseEntity<Result> deleteMatch(@PathVariable("matchId") Long matchId) {
        seriesService.deleteMatch(matchId);
        return success();
    }

    @PutMapping("round/match/{matchId}")
    public ResponseEntity<Result> changeMatchStatus(@PathVariable("matchId") Long matchId) {
        seriesService.changeMatchStatus(matchId);
        return success();
    }

    @GetMapping("round/match/{roundId}/{matchId}")
    public ResponseEntity<Result<SeriesMatchDetailVO>> getSeriesMatchDetail(@PathVariable("roundId") Long roundId,
                                                                            @PathVariable("matchId") Long matchId) {
        return success(seriesService.getSeriesMatchDetail(roundId, matchId));
    }

    @PostMapping("round/match")
    public ResponseEntity<Result> saveMatch(@RequestBody SeriesMatchSaveDTO dto) {
        seriesService.saveMatch(dto);
        return success();
    }

    @PostMapping("match/qualifying/rank")
    public ResponseEntity<Result<SeriesQualifyingMatchRankPageVO>> getSeriesQualifyingMatchRank(@RequestBody SeriesQualifyingMatchRankDTO dto) {
        return success(seriesService.getSeriesQualifyingMatchRank(dto));
    }

    @GetMapping("record/result/confirm/status/{recordId}/{status}")
    public ResponseEntity<Result> changeMatchRecordStatus(@PathVariable("recordId") Long recordId, @PathVariable("status") Integer status) {
        seriesService.changeMatchRecordStatus(recordId, status);
        return success();
    }

    @PostMapping("knockout/match/record")
    public ResponseEntity<Result<SeriesQualifyingMatchRankPageVO>> getKnockoutMatchRecord(@RequestBody SeriesKnockoutMatchRecordDTO dto) {
        return success(seriesService.getKnockoutMatchRecord(dto));
    }

    @PostMapping("match/finalists")
    public ResponseEntity<Result<SeriesMatchFinalistsPageVO>> getSeriesMatchFinalists(@RequestBody SeriesMatchFinalistsPageDTO dto) {
        return success(seriesService.getSeriesMatchFinalists(dto));
    }

    @PostMapping("match/candidate")
    public ResponseEntity<Result<SeriesMatchFinalistsPageVO>> getKnockoutMatchCandidate(@RequestBody SeriesMatchFinalistsPageDTO dto) {
        return success(seriesService.getKnockoutMatchCandidate(dto));
    }

    @GetMapping("match/finalists/{matchId}/{sportUserId}")
    public ResponseEntity<Result> addToFinalists(@PathVariable("matchId") Long matchId,
                                                 @PathVariable("sportUserId") Long sportUserId) {
        seriesService.addToFinalists(matchId, sportUserId);
        return success();
    }

    @DeleteMapping("match/finalists/{id}")
    public ResponseEntity<Result> deleteFinalists(@PathVariable("id") Long id) {
        seriesService.deleteFinalists(id);
        return success();
    }

}
