package com.antai.sport.http.server.management.api.business.course.service;

import com.antai.sport.http.server.common.service.CommonCodeService;
import com.antai.sport.http.server.common.vo.SysCodeDetailVO;
import com.antai.sport.http.server.constants.CourseType;
import com.antai.sport.http.server.management.api.business.course.converter.CourseConverter;
import com.antai.sport.http.server.management.api.business.course.dto.CourseItemSaveDTO;
import com.antai.sport.http.server.management.api.business.course.dto.CoursePageDTO;
import com.antai.sport.http.server.management.api.business.course.mapper.CourseBusinessMapper;
import com.antai.sport.http.server.management.api.business.course.vo.CourseDetailVO;
import com.antai.sport.http.server.management.api.business.course.vo.CourseItemVO;
import com.antai.sport.http.server.management.api.business.course.vo.CoursePageVO;
import com.antai.sport.http.server.repository.course.entity.Course;
import com.antai.sport.http.server.repository.course.entity.CourseItem;
import com.antai.sport.http.server.repository.course.mapper.CourseItemMapper;
import com.antai.sport.http.server.repository.course.mapper.CourseMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Service
public class CourseService {
    @Resource
    private CommonCodeService commonCodeService;
    @Resource
    private CourseMapper courseMapper;
    @Resource
    private CourseItemMapper courseItemMapper;

    @Resource
    private CourseBusinessMapper courseBusinessMapper;

    @Resource
    private CourseConverter courseConverter;

    public CoursePageVO getCoursePage(CoursePageDTO dto) {
        CoursePageVO result = new CoursePageVO();
        result.setPageNo(dto.getPageNo());
        Page<Course> pageParam = new Page<>(dto.getPageNo(), dto.getPageSize());
        pageParam.addOrder(new OrderItem("id", false));
        IPage<Course> coursePage = courseBusinessMapper.getCoursePage(pageParam);
        result.setData(coursePage.getRecords());
        result.setTotalCount(coursePage.getTotal());
        return result;
    }

    public void changeCourseStatus(Long id) {
        Course course = courseMapper.selectById(id);
        if (course.getStatus() == 10) {
            course.setStatus(20);
        } else {
            course.setStatus(10);
        }
        courseMapper.updateById(course);
    }

    public void deleteCourse(Long id) {
        Course course = courseMapper.selectById(id);
        course.setDeleted(1);
        courseMapper.updateById(course);
    }

    public CourseDetailVO getCourseDetail(Long id) {
        CourseDetailVO result = new CourseDetailVO();
        Course course;
        if (id == 0) {
            course = new Course();
            course.setStatus(10);
        } else {
            course = courseMapper.selectById(id);
        }
        result.setCourse(course);
        Map<String, List<SysCodeDetailVO>> codeMap = commonCodeService.getCodeByTypes(CourseType.CODE);
        result.setTypeList(codeMap.get(CourseType.CODE));
        return result;
    }

    public void saveCourse(Course course) {
        if (course.getId() == null || course.getId() == 0) {
            course.setStatus(10);
            courseMapper.insert(course);
        } else {
            courseMapper.updateById(course);
        }
    }

    public List<CourseItemVO> getCourseItem(Long courseId) {
        QueryWrapper<CourseItem> itemQuery = new QueryWrapper<>();
        itemQuery.lambda().eq(CourseItem::getCourseId, courseId).orderByAsc(CourseItem::getShowOrder)
                .orderByAsc(CourseItem::getId);
        return courseConverter.toCourseItemVO(courseItemMapper.selectList(itemQuery));
    }

    @Transactional
    public void saveCourseItem(CourseItemSaveDTO dto) {
        if (dto.getItemList() != null) {
            for (CourseItem item : dto.getItemList()) {
                if (item.getId() < 0) {
                    item.setId(null);
                    item.setCourseId(dto.getCourseId());
                    courseItemMapper.insert(item);
                } else {
                    courseItemMapper.updateById(item);
                }
            }
        }
        if (dto.getDeleteList() != null) {
            for (Long id : dto.getDeleteList()) {
                courseItemMapper.deleteById(id);
            }
        }
    }


}
