package com.antai.sport.http.server.management.api.business.auth.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.management.api.annotation.LoginUser;
import com.antai.sport.http.server.management.api.business.auth.dto.LoginRequestDTO;
import com.antai.sport.http.server.management.api.business.auth.dto.UserInfoResponseDTO;
import com.antai.sport.http.server.management.api.business.auth.service.AuthService;
import com.antai.sport.http.server.repository.sys.entity.SysUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("auth")
@RestController
@Api(tags = {"授权相关接口"})
public class AuthController {

    @Resource
    private AuthService authService;

    @ApiOperation("登录接口")
    @PostMapping("login")
    public ResponseEntity<Result> login(@RequestBody LoginRequestDTO loginParam) {
        return success(authService.login(loginParam));
    }

    @ApiOperation("获取用户信息")
    @GetMapping("/user/info")
    public ResponseEntity<Result<UserInfoResponseDTO>> getUserInfo(@LoginUser SysUser loginUser) {
        return success(authService.getUserInfo(loginUser));
    }

}
