package com.antai.sport.http.server.common.util;

import com.antai.sport.http.server.common.base.RespCodeEnum;
import com.antai.sport.http.server.common.base.Result;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author liming
 * @Date 2021/8/23 13:30
 * @Email lmmax@126.com
 * @Description:
 */
public class ResultUtil {
    public static ResponseEntity<Result> success() {
        Result result = new Result();
        result.setRespCode(RespCodeEnum.SUCCESS.getCode());
        result.setResultType(Result.SUCCESS);
        return new ResponseEntity<>(result, new HttpHeaders(), HttpStatus.OK);
    }

    public static ResponseEntity<Result> error(RespCodeEnum RespCodeEnum) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.getCode());
        Result.setRespMsg(RespCodeEnum.getMessage());
        Result.setResultType(Result.FAIL);
        return new ResponseEntity<>(Result, HttpStatus.OK);
    }

    public static ResponseEntity<Result> error(RespCodeEnum RespCodeEnum, String errorMsg) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.getCode());
        Result.setRespMsg(errorMsg);
        Result.setResultType(Result.FAIL);
        return new ResponseEntity<>(Result, HttpStatus.OK);
    }

    public static ResponseEntity<Result> error(RespCodeEnum RespCodeEnum, BindingResult bindingResult) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.getCode());
        Result.setRespMsg(RespCodeEnum.getMessage());
        Result.setResultType(Result.FAIL);
        StringBuilder errorStr = new StringBuilder();
        List<String> errorList = new ArrayList<>();
        for (int i = 0; i < bindingResult.getErrorCount(); i++) {
            ObjectError oe = bindingResult.getAllErrors().get(i);
            errorList.add(oe.getDefaultMessage());
            if (i == 0) {
                errorStr.append(oe.getDefaultMessage());
            } else {
                errorStr.append(",").append(oe.getDefaultMessage());
            }
        }
        Result.setData(errorStr.toString());
        return new ResponseEntity<>(Result, HttpStatus.OK);
    }

    public static <T> ResponseEntity<Result<T>> success(HttpHeaders httpHeaders, T data) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.SUCCESS.getCode());
        Result.setRespMsg(RespCodeEnum.SUCCESS.getMessage());
        Result.setData(data);
        Result.setResultType(Result.SUCCESS);
        return new ResponseEntity<>(Result, httpHeaders, HttpStatus.OK);
    }


    public static <T> ResponseEntity<Result<T>> success(T data) {
        Result Result = new Result();
        Result.setRespCode(RespCodeEnum.SUCCESS.getCode());
        Result.setRespMsg(RespCodeEnum.SUCCESS.getMessage());
        Result.setData(data);
        Result.setResultType(Result.SUCCESS);
        return new ResponseEntity<>(Result, new HttpHeaders(), HttpStatus.OK);
    }

    public static <T> ResponseEntity<Result<T>> success(Result<T> result) {
        result.setRespCode(RespCodeEnum.SUCCESS.getCode());
        result.setResultType(Result.SUCCESS);
        return new ResponseEntity<>(result, new HttpHeaders(), HttpStatus.OK);
    }
}
