package com.antai.sport.http.server.common.resolver;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.common.jwt.TokenService;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportUserCacheMapper;
import io.jsonwebtoken.Claims;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

import javax.annotation.Resource;

public class SportUserArgumentResolver implements HandlerMethodArgumentResolver {

    @Value("${project.header-token-key}")
    private String headerTokenKey;
    @Value("${project.jwt.subject-key}")
    private String subjectKey;

    @Resource
    private SportUserCacheMapper sportUserCacheMapper;
    @Resource
    private TokenService tokenService;

    /**
     * 判断是否支持要转换的参数类型
     */
    @Override
    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().isAssignableFrom(SportUser.class);
    }

    /**
     * 当支持后进行相应的转换 做业务操作
     */
    @Override
    public Object resolveArgument(MethodParameter methodParameter,
                                  ModelAndViewContainer modelAndViewContainer,
                                  NativeWebRequest request,
                                  WebDataBinderFactory webDataBinderFactory) throws Exception {
        //从请求头中获参数信息
        String token = request.getHeader(headerTokenKey);

        if (token == null || token.isEmpty()) {
            throw new BusinessException("token信息错误");
        }

        Claims claims = tokenService.validateToken(token);
        if (claims == null) {
            throw new BusinessException("token解析异常");
        }
        String phone = claims.get(subjectKey).toString();
        SportUser sportUser = sportUserCacheMapper.getByPhone(phone);

        if (sportUser == null) {
            throw new BusinessException("当前用户不存在");
        }

        return sportUser;

    }
}
