package com.antai.sport.http.server.common.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author liming
 * @Date 2021/8/20 11:38
 * @Email lmmax@126.com
 * @Description:
 */
@Component
public class TokenService {
    @Value("${project.jwt.secret:null}")
    private String secret;
    @Value("${project.jwt.prefix:null}")
    private String tokenPrefix;
    @Value("${project.jwt.long-token-expire:0}")
    private long longTokenExpire;
    @Value("${project.jwt.short-token-expire:0}")
    private long shortTokenExpire;
    @Value("${project.jwt.subject-key:null}")
    private String subjectKey;
    @Value("${project.jwt.long-token-key:null}")
    private String longTokenKey;

    public TokenVO initToken(String username) {
        Map<String, Object> claims = new HashMap<>();
        long currentTimeMillis = System.currentTimeMillis();
        claims.put(subjectKey, username);
        String shortToken = tokenPrefix + " " + Jwts.builder()
                .setClaims(claims)
                .setIssuedAt(new Date(currentTimeMillis))
                .setExpiration(new Date(currentTimeMillis + shortTokenExpire))
                .signWith(SignatureAlgorithm.HS512, secret)
                .compact();
        claims.put(longTokenKey, true);
        String longToken = tokenPrefix + " " + Jwts.builder()
                .setClaims(claims)
                .setIssuedAt(new Date(currentTimeMillis))
                .setExpiration(new Date(currentTimeMillis + longTokenExpire))
                .signWith(SignatureAlgorithm.HS512, secret)
                .compact();
        return new TokenVO(longToken, shortToken);
    }


    public Claims validateToken(String token) {
        try {
            Claims claims = Jwts.parser()
                    .setSigningKey(secret)
                    .parseClaimsJws(token.replace(tokenPrefix, ""))
                    .getBody();
            if (claims != null) {
                return claims;
            }
        } catch (Exception ignored) {

        }
        return null;
    }

}
