package com.antai.sport.http.server.common.exception;

import com.antai.sport.http.server.common.base.RespCodeEnum;
import com.antai.sport.http.server.common.base.Result;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author liming
 * @Date 2021/8/20 11:53
 * @Email lmmax@126.com
 * @Description:
 */
@RestController
public class CustomerErrorController implements ErrorController {

    @RequestMapping("/error")
    public ResponseEntity<Result> handleError(HttpServletRequest request) {
        Result result = new Result();
        Integer statusCode = (Integer) request.getAttribute("javax.servlet.error.status_code");
        result.setRespCode(statusCode.toString());
        if (RespCodeEnum.NOT_LOGIN.getCode().equals(result.getRespCode())) {
            result.setRespMsg(RespCodeEnum.NOT_LOGIN.getMessage());
        } else {
            result.setRespMsg(RespCodeEnum.SYSTEM_ERROR.getMessage());
        }
        result.setResultType(Result.FAIL);
        return new ResponseEntity<>(result, HttpStatus.OK);
    }

    @Override
    public String getErrorPath() {
        return "/error";
    }
}
