package com.antai.sport.http.server.common.base;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author liming
 * @Date 2021/8/20 11:19
 * @Email lmmax@126.com
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Result<T> {

    public final static Integer SUCCESS = 1;
    public final static Integer FAIL = 2;

    @ApiModelProperty(value = "请求结果 1:成功 2:失败")
    private Integer resultType = SUCCESS;
    @ApiModelProperty(value = "响应Code")
    private String respCode;
    @ApiModelProperty(value = "响应信息")
    private String respMsg;
    @ApiModelProperty(value = "异常代码")
    private String errorCode;
    @ApiModelProperty(value = "数据包")
    private T data;
    @ApiModelProperty(value = "是否需要刷新Token")
    private boolean refreshToken;
    @ApiModelProperty(value = "长Token,仅当短Token失效时使用")
    private String longToken;
    @ApiModelProperty(value = "短Token")
    private String shortToken;


}
