package com.antai.sport.http.server.server.api.business.sportusergamecurrency.service;

import com.antai.sport.http.server.constants.GameCurrencyLogType;
import com.antai.sport.http.server.repository.shop.entity.SportUserGameCurrency;
import com.antai.sport.http.server.repository.shop.entity.SportUserGameCurrencyLog;
import com.antai.sport.http.server.repository.shop.mapper.SportUserGameCurrencyLogMapper;
import com.antai.sport.http.server.repository.shop.mapper.SportUserGameCurrencyMapper;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.dto.SportUserCurrencyPageDTO;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.dto.SportUserCurrencyPageVO;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.dto.SportUserCurrencyVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Service
public class SportUserGameCurrencyService {
    @Resource
    private SportUserGameCurrencyMapper sportUserGameCurrencyMapper;
    @Resource
    private SportUserGameCurrencyLogMapper sportUserGameCurrencyLogMapper;

    public void addCurrency(Long sportUserId, Integer currency, Integer sourceType, Long sourceId, String description) {
        SportUserGameCurrency userGameCurrency =
                sportUserGameCurrencyMapper.selectOne(new QueryWrapper<SportUserGameCurrency>().lambda()
                        .eq(SportUserGameCurrency::getSportUserId, sportUserId));


        if (userGameCurrency == null) {
            userGameCurrency = new SportUserGameCurrency();
            userGameCurrency.setSportUserId(sportUserId);
            userGameCurrency.setAmmount(currency);
            userGameCurrency.setCtDate(LocalDateTime.now());
            sportUserGameCurrencyMapper.insert(userGameCurrency);
        } else {
            userGameCurrency.setAmmount(userGameCurrency.getAmmount() + currency);
            sportUserGameCurrencyMapper.updateById(userGameCurrency);
        }
        SportUserGameCurrencyLog gameCurrencyLog = new SportUserGameCurrencyLog();
        gameCurrencyLog.setSportUserId(sportUserId);
        gameCurrencyLog.setAmmount(currency);
        gameCurrencyLog.setSourceType(sourceType);
        gameCurrencyLog.setSourceId(sourceId);
        gameCurrencyLog.setCtDate(LocalDateTime.now());
        gameCurrencyLog.setType(GameCurrencyLogType.ADD);
        gameCurrencyLog.setDescription(description);
        sportUserGameCurrencyLogMapper.insert(gameCurrencyLog);
    }

    public SportUserCurrencyVO getUserCurrency(Long sportUserId) {
        SportUserCurrencyVO result = new SportUserCurrencyVO();
        SportUserGameCurrency userGameCurrency =
                sportUserGameCurrencyMapper.selectOne(new QueryWrapper<SportUserGameCurrency>().lambda()
                        .eq(SportUserGameCurrency::getSportUserId, sportUserId));
        if (userGameCurrency == null) {
            result.setCurrency(0);
        } else {
            result.setCurrency(userGameCurrency.getAmmount());
        }
        return result;
    }

    public List<SportUserCurrencyPageVO> getUserCurrencyPage(Long sportUserId, SportUserCurrencyPageDTO param) {

        QueryWrapper<SportUserGameCurrencyLog> logQuery = new QueryWrapper<>();
        logQuery.lambda().eq(SportUserGameCurrencyLog::getSportUserId, sportUserId);
        Page<SportUserGameCurrencyLog> pageParam = new Page<>(param.getPageNo(), param.getPageSize());
        pageParam.addOrder(new OrderItem("id", false));
        List<SportUserGameCurrencyLog> logList =
                sportUserGameCurrencyLogMapper.selectPage(pageParam, logQuery).getRecords();
        if(logList.isEmpty()){
            return new ArrayList<>();
        }
        List<SportUserCurrencyPageVO> resultList = new ArrayList<>(logList.size());
        for (SportUserGameCurrencyLog log:logList){
            SportUserCurrencyPageVO logVO = new SportUserCurrencyPageVO();
            logVO.setId(log.getId());
            logVO.setTime(log.getCtDate());
            logVO.setType(log.getType());
            logVO.setAmount(log.getAmmount());
            logVO.setDesc(log.getDescription());
            resultList.add(logVO);
        }
        return resultList;
    }
}
