package com.antai.sport.http.server.server.api.business.series.service;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.repository.series.entity.Series;
import com.antai.sport.http.server.repository.series.entity.SeriesApply;
import com.antai.sport.http.server.repository.series.mapper.SeriesMapper;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.antai.sport.http.server.server.api.business.series.converter.SeriesConverter;
import com.antai.sport.http.server.server.api.business.series.mapper.SeriesBusinessMapper;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesApplyPreLoadVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesDetailsVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesListVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class SeriesService {

    @Resource
    private SeriesMapper seriesMapper;
    @Resource
    private SportUserMapper sportUserMapper;

    @Resource
    private SeriesConverter seriesConverter;

    @Resource
    private SeriesBusinessMapper seriesBusinessMapper;

    public List<SeriesListVO> getSeriesList() {
        return seriesBusinessMapper.getSeriesList();
    }

    public SeriesDetailsVO getSeriesDetails(Long id, Long sportUserId) {
        Series series = seriesMapper.selectById(id);
        if (series == null) {
            throw new BusinessException("您查询的系列赛信息不存在");
        }
        LocalDateTime now = LocalDateTime.now();
        Integer status;
        if (series.getFinished()) {
            status = 40;
        } else if (now.isBefore(series.getApplyStartTime())) {
            status = 30;
        } else if (now.isAfter(series.getApplyStartTime()) && now.isBefore(series.getApplyEndTime())) {
            status = 10;
        } else {
            status = 20;
        }
        SeriesDetailsVO result = seriesConverter.toSeriesDetailVO(series, status);
        result.setNoticeList(seriesBusinessMapper.getSeriesNotice(id));
        result.setApplied(seriesBusinessMapper.checkUserSeriesIsApplied(id, sportUserId));
        result.setRoundList(seriesBusinessMapper.getSeriesRound(id));
        return result;
    }

    public SeriesApplyPreLoadVO getSeresApplyPreLoadInfo(Long sportUserId, Long seriesId) {
        SportUser sportUser = sportUserMapper.selectById(sportUserId);
        SeriesApplyPreLoadVO result = seriesConverter.toSeriesApplyPreLoadVO(sportUser);
        result.setAreaList(seriesBusinessMapper.getSeriesAreaList(seriesId));
        SeriesApply seriesApply = seriesBusinessMapper.getLatestUserSeriesApplyInfo(sportUserId);
        if(seriesApply!=null){
            result.setRealName(seriesApply.getName());
            result.setIdCard(seriesApply.getIdcard());
        }

        return result;
    }


}
