package com.antai.sport.http.server.server.api.business.series.mapper;

import com.antai.sport.http.server.repository.series.entity.SeriesApply;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesAreaVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesListVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesNoticeVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesRoundVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface SeriesBusinessMapper {

    List<SeriesListVO> getSeriesList();

    List<SeriesNoticeVO> getSeriesNotice(@Param("seriesId") Long seriesId);

    List<SeriesRoundVO> getSeriesRound(@Param("seriesId") Long seriesId);

    Boolean checkUserSeriesIsApplied(@Param("seriesId") Long seriesId, @Param("sportUserId") Long sportUserId);

    List<SeriesAreaVO> getSeriesAreaList(@Param("seriesId") Long seriesId);

    SeriesApply getLatestUserSeriesApplyInfo(@Param("sportUserId") Long sportUserId);
}
