package com.antai.sport.http.server.server.api.business.series.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.series.service.SeriesService;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesApplyPreLoadVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesDetailsVO;
import com.antai.sport.http.server.server.api.business.series.vo.SeriesListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("series")
@Api(tags = {"系列赛接口"})
public class SeriesController {
    @Resource
    private SeriesService seriesService;

    @GetMapping("list")
    @ApiOperation(value = "查询系列赛列表")
    public ResponseEntity<Result<List<SeriesListVO>>> getSeriesList() {
        return success(seriesService.getSeriesList());
    }

    @GetMapping("{id}/{sportUserId}")
    @ApiOperation(value = "查询系列赛详情")
    public ResponseEntity<Result<SeriesDetailsVO>> getSeriesDetails(
            @PathVariable("id") Long id,
            @PathVariable("sportUserId") Long sportUserId) {
        return success(seriesService.getSeriesDetails(id, sportUserId));
    }

    @GetMapping("apply/preload/{seriesId}/{sportUserId}")
    public ResponseEntity<Result<SeriesApplyPreLoadVO>> getSeresApplyPreLoadInfo(
            @PathVariable("seriesId") Long seriesId,
            @PathVariable("sportUserId") Long sportUserId) {
        return success(seriesService.getSeresApplyPreLoadInfo(sportUserId, seriesId));
    }


}
