package com.antai.sport.http.server.server.api.business.praise.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.praise.dto.ReqPraise;
import com.antai.sport.http.server.server.api.business.praise.service.PraiseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("praise")
@Api(tags = {"点赞"})
public class PraiseController {
    @Resource
    private PraiseService praiseService;

    @ApiOperation("点赞")
    @PostMapping
    public ResponseEntity<Result> praise(@RequestBody ReqPraise param) {
        praiseService.praise(param);
        return success();
    }

}
