package com.antai.sport.http.server.repository.roommode.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-04-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class RoomModePlayerRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 房间id
     */
    private Long roomId;

    /**
     * 玩家id
     */
    private Long playerId;

    /**
     * 比赛用时(秒)
     */
    private Integer duration;

    /**
     * 比赛名次
     */
    private Integer matchRank;

    /**
     * 比赛完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 骑行总长度
     */
    private BigDecimal distance;

    /**
     * 爬坡距离
     */
    private BigDecimal climbDistance;

    /**
     * 平均功率
     */
    private BigDecimal avgFtp;

    /**
     * 平均速度
     */
    private BigDecimal avgSpeed;

    private Integer calorie;
    private BigDecimal weight;
    private BigDecimal oneMinutesFtp;
    private BigDecimal fiveMinutesFtp;
    private BigDecimal twentyMinutesFtp;
    private BigDecimal oneMinutesWkg;
    private BigDecimal fiveMinutesWkg;
    private BigDecimal twentyMinutesWkg;
    private BigDecimal score;

    /**
     * 比赛状态10:完成比赛 20:未完成比赛
     */
    private Integer status;

    private Boolean finished;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
