package com.antai.sport.http.server.mobile.api.business.sport.social.service;

import com.antai.sport.http.server.constants.ChartHistoryStatus;
import com.antai.sport.http.server.mobile.api.business.sport.social.dto.ReqChatHistoryQueryParam;
import com.antai.sport.http.server.mobile.api.business.sport.social.dto.ReqChatMessage;
import com.antai.sport.http.server.mobile.api.business.sport.social.dto.RespChatHistory;
import com.antai.sport.http.server.mobile.api.business.sport.social.mapper.SportChatHistoryBusinessMapper;
import com.antai.sport.http.server.repository.sport.entity.SportChatHistory;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportChatHistoryMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;

@Service
public class ChatService {

    @Resource
    private SportChatHistoryMapper sportChatHistoryMapper;
    @Resource
    private SportChatHistoryBusinessMapper sportChatHistoryBusinessMapper;

    public Long sendMessage(ReqChatMessage message, SportUser loginUser) {
        SportChatHistory history = new SportChatHistory();
        history.setSenderId(loginUser.getId());
        history.setReceiverId(message.getReceiverId());
        history.setContent(message.getContent());
        history.setRoomKey(message.getRoomKey());
        history.setCtDate(LocalDateTime.now());
        history.setStatus(ChartHistoryStatus.UN_READ);
        sportChatHistoryMapper.insert(history);
        return history.getId();
    }

    public List<RespChatHistory> getChatHistory(ReqChatHistoryQueryParam param, SportUser loginUser) {
        if (param.getQuerySize() == null || param.getQuerySize() == 0) {
            param.setQuerySize(20);
        }
        List<RespChatHistory> resultList = sportChatHistoryBusinessMapper.getChatHistory(param);
        //更新消息状态为已读
        sportChatHistoryBusinessMapper.updateChartHistoryStatus(param.getRoomKey(), loginUser.getId());
        Collections.reverse(resultList);
        return resultList;
    }
}
