package com.antai.sport.http.server.mobile.api.business.sport.social.controller;

import com.antai.sport.http.server.mobile.api.business.sport.social.dto.ReqFriendRequestResponse;
import com.antai.sport.http.server.mobile.api.business.sport.social.service.FriendsService;
import com.antai.sport.http.server.common.annotation.LoginSportUser;
import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.mobile.api.business.sport.social.dto.RespFriendRequestToMe;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@Api(tags = {"社交相关接口"})
@RequestMapping("/friends")
public class FriendsController {

    @Resource
    private FriendsService friendsService;

    @ApiOperation(value = "获取好友列表", notes = "结果为好友id数组")
    @GetMapping
    public ResponseEntity<Result<List<Long>>> getFriends(@LoginSportUser SportUser loginUser) {
        return success(friendsService.getFriends(loginUser));
    }

    @ApiOperation(value = "查询发给我的好友请求")
    @GetMapping("/requests")
    public ResponseEntity<Result<List<RespFriendRequestToMe>>> getFriendsRequestToMe(@LoginSportUser SportUser loginUser) {
        return success(friendsService.getFriendsRequestToMe(loginUser));
    }

    @ApiOperation(value = "发送好友请求", notes = "data中为好友请求持久化Id,当重复提交待确认好友申请或已经是好友时会报业务异常，应在前端展示")
    @GetMapping("/send/request/{targetUserId}")
    public ResponseEntity<Result<Long>> sendFriendRequest(@PathVariable("targetUserId") Long targetUserId, @LoginSportUser SportUser loginUser) {
        return success(friendsService.sendFriendRequest(targetUserId, loginUser));
    }

    @ApiOperation(value = "响应好友请求")
    @PostMapping("/response")
    public ResponseEntity<Result> requestResponse(@RequestBody ReqFriendRequestResponse param, @LoginSportUser SportUser loginUser) {
        friendsService.requestResponse(param, loginUser);
        return success();
    }


}
