package com.antai.sport.http.server.management.api.business.auth.service;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.common.jwt.TokenService;
import com.antai.sport.http.server.common.jwt.TokenVO;
import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.management.api.business.auth.converter.AuthConverter;
import com.antai.sport.http.server.management.api.business.auth.dto.LoginRequestDTO;
import com.antai.sport.http.server.management.api.business.auth.dto.UserInfoResponseDTO;
import com.antai.sport.http.server.repository.sys.entity.SysUser;
import com.antai.sport.http.server.repository.sys.mapper.SysUserMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import javax.annotation.Resource;
import java.util.List;

@Service
public class AuthService {

    @Resource
    private SysUserMapper sysUserMapper;

    @Resource
    private TokenService tokenService;

    @Resource
    private AuthConverter authConverter;

    /**
     * 登录
     *
     * @param loginParam
     * @return
     */
    public Result login(LoginRequestDTO loginParam) {
        if (StringUtils.isBlank(loginParam.getUsername())) {
            throw new BusinessException("请输入用户名");
        }
        if (StringUtils.isBlank(loginParam.getPassword())) {
            throw new BusinessException("请输入密码");
        }
        List<SysUser> userList = sysUserMapper.selectList(new QueryWrapper<SysUser>()
                .eq("username", loginParam.getUsername())
                .eq("deleted", DeleteStatus.UNDELETED));
        if (userList.isEmpty()) {
            throw new BusinessException("用户名或密码错误");
        }
        SysUser user = userList.get(0);
        String hashPwd = DigestUtils.md5DigestAsHex(loginParam.getPassword().getBytes());
        if (!hashPwd.equals(user.getPassword())) {
            throw new BusinessException("用户名或密码错误");
        }

        Result result = new Result();
        TokenVO tokenVO = tokenService.initToken(loginParam.getUsername());
        result.setLongToken(tokenVO.getLongToken());
        result.setShortToken(tokenVO.getShortToken());
        result.setRefreshToken(true);
        result.setRespMsg("登录成功");
        return result;
    }

    /**
     * 获取用户信息
     *
     * @param loginUser
     * @return
     */
    public UserInfoResponseDTO getUserInfo(SysUser loginUser) {
        return authConverter.toUserInfoResponseDTO(loginUser);
    }
}
