import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { TenantPackageApi } from '#/api/system/sysTenantPackage';

import { useAccess } from '@vben/access';
import { DictEnum } from '@vben/constants';

import { apiChangeStatus } from '#/api/system/sysTenantPackage';
import { getDictOptions } from '#/utils/dict';

const { hasAccessByCodes } = useAccess();

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'packageName',
    label: '套餐名称',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'menuIds',
  //   label: '关联菜单ID',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_COMMON_STATUS, true),
    },
    fieldName: 'status',
    label: '状态',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<TenantPackageApi.TenantPackage>,
): VxeTableGridOptions<TenantPackageApi.TenantPackage>['columns'] {
  return [
    {
      title: '套餐名称',
      field: 'packageName',
    },
    // {
    //   title: '关联菜单ID',
    //   field: 'menuIds',
    // },
    {
      title: '状态',
      field: 'status',
      cellRender: {
        name: 'CellSwitch',
        props: {
          api: apiChangeStatus,
          confirm: true,
          disabled: () => {
            return !hasAccessByCodes(['system:tenantPackage:edit']);
          },
        },
      },
    },
    {
      title: '备注',
      field: 'remark',
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'packageName',
          nameTitle: '租户套餐',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'edit', // 默认的删除按钮
            accessCode: ['system:tenantPackage:edit'],
          },
          {
            code: 'delete', // 默认的删除按钮
            accessCode: ['system:tenantPackage:remove'],
          },
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
