import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysLogApi } from '#/api/system/log/sysLog';

import { DictEnum } from '@vben/constants';

import { getDictOptions, getTagDicts } from '#/utils/dict';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'title',
  //   label: '操作模块',
  // },
  {
    component: 'Input',
    fieldName: 'operName',
    label: '操作人员',
  },
  {
    component: 'Input',
    fieldName: 'title',
    label: '操作模块',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_OPER_TYPE, true),
    },
    fieldName: 'businessType',
    label: '操作类型',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_SUCCESS_STATUS),
    },
    fieldName: 'status',
    label: '状态',
  },
  {
    component: 'RangePicker',
    fieldName: 'createTime',
    label: '操作时间',
    componentProps: {
      valueFormat: 'YYYY-MM-DD HH:mm:ss',
    },
  },
  // {
  //   component: 'Input',
  //   fieldName: 'params',
  //   label: '请求参数',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'time',
  //   label: '执行时长(毫秒)',
  // },
  {
    component: 'Input',
    fieldName: 'ip',
    label: 'IP地址',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'result',
  //   label: '结果',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'errorMsg',
  //   label: '错误消息',
  // },
];

export function useColumns(): VxeTableGridOptions<SysLogApi.SysLog>['columns'] {
  // onActionClick: OnActionClickFn<SysLogApi.SysLog>,
  return [
    {
      title: '操作模块',
      field: 'title',
    },
    {
      title: '操作人员',
      field: 'operName',
    },
    {
      title: '业务类型',
      field: 'businessType',
      cellRender: {
        name: 'CellTag',
        options: [getTagDicts(DictEnum.SYS_OPER_TYPE, true)],
      },
    },
    // {
    //   title: '操作类别',
    //   field: 'operatorType',
    // cellRender: { name: 'CellTag', options: getTagDicts() },
    // },
    // {
    //   title: '用户操作',
    //   field: 'operation',
    // },
    {
      title: '操作方法',
      field: 'method',
    },
    // {
    //   title: '请求参数',
    //   field: 'params',
    // },
    {
      title: '执行时长(毫秒)',
      field: 'costTime',
    },
    {
      title: 'IP地址',
      field: 'ip',
    },
    // {
    //   title: '结果',
    //   field: 'result',
    // },
    {
      title: '操作状态',
      field: 'status',
      slots: {
        default: 'status',
      },
      // cellRender: { name: 'CellTag', options: getTagDicts() },
    },
    { field: 'createTime', title: '操作日期', formatter: 'formatDateTime' },
    // {
    //   title: '错误消息',
    //   field: 'errorMsg',
    // },
    {
      align: 'right',
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: 'SysLog',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     'edit', // 默认的编辑按钮
      //     'delete', // 默认的删除按钮
      //   ],
      // },
      slots: { default: 'action' },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
