import type { VbenFormSchema } from '#/adapter/form';
import type { OnActionClickFn, VxeTableGridOptions } from '#/adapter/vxe-table';
import type { SysDeptApi } from '#/api/auth/dept';

import { DictEnum } from '@vben/constants';

// import { changeStatus } from '#/api/auth/dept';
import { getDictOptions } from '#/utils/dict';

export const querySchema: VbenFormSchema[] = [
  // {
  //   component: 'Input',
  //   fieldName: 'parentId',
  //   label: '父级部门',
  // },
  {
    component: 'Input',
    fieldName: 'name',
    label: '部门名称',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'nodePath',
  //   label: '祖级关系',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'isLeaf',
  //   label: '叶子节点',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'orderNum',
  //   label: '显示顺序',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_COMMON_STATUS, true),
    },
    fieldName: 'status',
    label: '状态',
  },
];

export function useColumns(
  onActionClick: OnActionClickFn<SysDeptApi.Dept>,
): VxeTableGridOptions<SysDeptApi.Dept>['columns'] {
  return [
    // {
    //   title: '父级部门',
    //   field: 'parentId',
    //   width: 120,
    // },
    {
      title: '部门名称',
      field: 'name',
      align: 'left',
      fixed: 'left',
      treeNode: true,
      // width: 120,
    },
    // {
    //   title: '祖级关系',
    //   field: 'nodePath',
    //   width: 120,
    // },
    // {
    //   title: '叶子节点',
    //   field: 'isLeaf',
    //   width: 120,
    // },
    {
      title: '显示顺序',
      field: 'orderNum',
      width: 120,
    },
    {
      title: '状态',
      field: 'status',
      cellRender: { name: 'CellTag' },
      // cellRender: {
      //   name: 'CellSwitch',
      //   props: {
      //     api: changeStatus,
      //     confirm: true,
      //   },
      // },
    },
    {
      align: 'right',
      cellRender: {
        attrs: {
          nameField: 'name',
          nameTitle: '部门',
          onClick: onActionClick,
        },
        name: 'CellOperation',
        options: [
          {
            code: 'append',
            text: '新增下级',
            accessCode: ['auth:dept:add'],
          },
          {
            // 默认的编辑按钮
            code: 'edit',
            accessCode: ['auth:dept:edit'],
          },
          {
            // 默认的删除按钮
            code: 'delete',
            accessCode: ['auth:dept:remove'],
          },
        ],
      },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
