import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace TenantPackageApi {
  export interface TenantPackage extends BaseModel {
    /**
     * 套餐名称
     */
    packageName?: string;
    /**
     * 关联菜单ID
     */
    menuIds?: number | string;

    /**
     * 状态（1正常 0停用）
     */
    status?: number;

    /**
     * 备注
     */
    remark?: string;
  }
}

/**
 * 查询租户套餐列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/tenantPackage/page', { params });
}
/**
 * 租户套餐下拉框
 * @returns 下拉框
 */
export function apiSelectList() {
  return requestClient.get<TenantPackageApi.TenantPackage[]>(
    '/system/tenantPackage/selectList',
  );
}
/**
 * 查询租户套餐详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/tenantPackage/${id}`);
}
/**
 * 新增租户套餐
 * @param data
 */
export function apiAdd(data: TenantPackageApi.TenantPackage) {
  return requestClient.post('/system/tenantPackage', data);
}
/**
 * 修改租户套餐
 * @param data
 */
export function apiUpdate(data: TenantPackageApi.TenantPackage) {
  return requestClient.put('/system/tenantPackage', data);
}
/**
 * 删除租户套餐
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/tenantPackage/${id}`);
}
/**
 * 导出租户套餐
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/system/tenantPackage/export', params);
  // return commonExport('/demo/excel/exportWithOptions', params);
}

/**
 * 修改租户套餐状态
 * @param data
 */
export function apiChangeStatus(data: TenantPackageApi.TenantPackage) {
  return requestClient.put('/system/tenantPackage/changeStatus', data);
}
