import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace SysJobLogApi {
  export interface SysJobLog extends BaseModel {
    /**
     * 任务id
     */
    jobId: number;

    /**
     * 执行器任务handler
     */
    executorHandler: string;
    /**
     * 参数
     */
    params?: string;
    /**
     * 任务状态  1：成功  0：失败
     */
    status: number;

    /**
     * 执行信息
     */
    handleMsg: string;
    /**
     * 执行耗时(单位：毫秒)
     */
    costTime: number;

    /**
     * 调度时间
     */
    triggerTime: string;
  }
}

/**
 * 查询定时任务日志列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/jobLog/page', { params });
}
/**
 * 查询定时任务日志详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/jobLog/${id}`);
}
// /**
//  * 新增定时任务日志
//  * @param data
//  */
// export function apiAdd(data: SysJobLogApi.SysJobLog) {
//   return requestClient.post('/app/sysJobLog', data);
// }
// /**
//  * 修改定时任务日志
//  * @param data
//  */
// export function apiUpdate(data: SysJobLogApi.SysJobLog) {
//   return requestClient.put('/app/sysJobLog', data);
// }
/**
 * 删除定时任务日志
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/jobLog/${id}`);
}
/**
 * 导出定时任务日志
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/system/jobLog/export', params);
}
