export type ID = number | string;
export type IDS = (number | string)[];

export interface QueryParam {
  key?: null | number | string;
  [key: string]: any;
}

export interface PageQuery extends QueryParam {
  pageNo: number;
  pageSize: number;
}

/**
 * 分页信息
 * @param data 结果集
 * @param total 总数
 */
export interface PageResult<T = any> {
  data: T[];
  totalCount: number;
}

export interface DetailParam {
  id: number;
  isEnable?: number;
}

export interface DetailSaveParam<T> {
  entity: T;
}

// export interface BasicFetchResult<T extends any> {
//   items: T
//   total: number
// }

export interface BaseModel {
  id?: number;
  deleted?: number;
  createTime?: Date;
  createBy?: number;
  updateTime?: Date;
  updateBy?: number;
}

export interface Option {
  key: number;
  value: string;
  children?: Option[];
  parentId?: number;
  [key: string]: any;
}
export interface OptionInfo {
  value: string;
  parentId: number;
}
