import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace SysDeptApi {
  export interface Dept extends BaseModel {
    parentId?: number;
    name?: string;
    // leader?: string;
    // email?: string;
    // phone?: string;
    // path?: string;
    nodePath?: string;
    // pageName?: string;
    orderNum?: number;
    // isLeaf?: number;
    status?: number;
    remark?: string;
    children?: Dept[];
  }
  /**
   * @description: 部门树
   */
  export interface DeptTreeOption {
    id: number;
    /**
     * antd组件必须要这个属性 实际是没有这个属性的
     */
    key: string;
    parentId: number;
    name: string;
    weight: number;
    children?: DeptTreeOption[];
  }
}

export function findList(params: PageQuery) {
  return requestClient.get('/system/dept/list', { params });
}

export function deleteOne(id: number) {
  return requestClient.delete(`/system/dept/${id}`);
}

export function getDetail(id: number) {
  return requestClient.get(`/system/dept/${id}`);
}

/**
 * 新增部门
 * @param data
 */
export function apiAdd(data: SysDeptApi.Dept) {
  return requestClient.post('/system/dept', data);
}
/**
 * 修改部门
 * @param data
 */
export function apiUpdate(data: SysDeptApi.Dept) {
  return requestClient.put('/system/dept', data);
}

export function treeList() {
  return requestClient.get('/system/dept/tree');
}

// export function changeStatus(data: SysDeptApi.Dept) {
//   return requestClient.post('/system/dept/changeStatus', { entity: data });
// }

export function exportDetail(params: PageQuery) {
  return commonExport('/system/dept/export', params);
}
