import type { VNode } from 'vue';

import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { LoginLogApi } from '#/api/system/log/loginLog';

import { DictEnum } from '@vben/constants';

import { getDictOptions } from '#/utils/dict';
import { renderBrowserIcon, renderOsIcon } from '#/utils/render';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'userName',
    label: '用户名',
  },
  {
    component: 'Input',
    fieldName: 'ipaddr',
    label: '登录IP地址',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(DictEnum.SYS_SUCCESS_STATUS),
    },
    fieldName: 'status',
    label: '登录状态',
  },
  {
    component: 'RangePicker',
    fieldName: 'dateTime',
    label: '访问时间',
  },
];

export function useColumns(): VxeTableGridOptions<LoginLogApi.LoginLog>['columns'] {
  return [
    {
      title: '用户名',
      field: 'userName',
    },
    {
      title: '客户端密钥',
      field: 'clientKey',
    },
    // {
    //   title: '设备类型',
    //   field: 'deviceType',
    //   // cellRender: { name: 'CellTag', options: [getTagDicts()] },
    // },

    {
      title: '登录IP地址',
      field: 'ipaddr',
    },
    // {
    //   title: '登录地点',
    //   field: 'loginLocation',
    // },
    {
      title: '浏览器类型',
      field: 'browser',
      slots: {
        default: ({ row }) => {
          return renderBrowserIcon(row.browser || '', true) as VNode;
        },
      },
    },
    {
      title: '操作系统',
      field: 'os',
      slots: {
        default: ({ row }) => {
          /**
           *  Windows 10 or Windows Server 2016 太长了 分割一下 详情依旧能看到详细的
           */
          let value = row.os;
          if (value) {
            const split = value.split(' or ');
            if (split.length === 2) {
              value = split[0];
            }
          }
          return renderOsIcon(value || '', true) as VNode;
        },
      },
    },
    {
      title: '登录状态',
      field: 'status',
      slots: {
        default: 'status',
      },
    },
    {
      title: '提示消息',
      field: 'msg',
    },
    {
      title: '访问时间',
      field: 'loginTime',
      formatter: 'formatDateTime',
    },
    {
      align: 'right',
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: '系统登录日志',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'edit',
      //       accessCode: ['log:sysLoginLog:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       accessCode: ['log:sysLoginLog:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      slots: { default: 'action' },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
