import type { VbenFormSchema } from '#/adapter/form';
import type { VxeTableGridOptions } from '#/adapter/vxe-table';
import type { EmployeeInfoApi } from '#/api/hr/employeeModel';

import { getDictOptions } from '#/utils/dict';

import { HrDictEnum } from '../dict-enum';

export const querySchema: VbenFormSchema[] = [
  {
    component: 'Input',
    fieldName: 'plate',
    label: '板块',
  },
  {
    component: 'Input',
    fieldName: 'firstLevelDepartment',
    label: '一级部门',
  },
  {
    component: 'Input',
    fieldName: 'secondLevelDepartment',
    label: '二级部门',
  },
  {
    component: 'Input',
    fieldName: 'thirdLevelDepartment',
    label: '三级部门',
  },
  {
    component: 'Input',
    fieldName: 'employeeNo',
    label: '工号',
  },
  {
    component: 'Input',
    fieldName: 'jobLevel',
    label: '职级',
  },
  {
    component: 'Input',
    fieldName: 'position',
    label: '岗位',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_SEQUENCE),
    },
    fieldName: 'sequence',
    label: '序列',
  },
  {
    component: 'Input',
    fieldName: 'name',
    label: '姓名',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_USER_SEX),
    },
    fieldName: 'gender',
    label: '性别',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'idCardNumber',
  //   label: '身份证号码',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'birthDate',
  //   label: '出生日期',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'age',
  //   label: '年龄',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_AGE_GROUP),
    },
    fieldName: 'ageGroup',
    label: '年龄段',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'nativePlace',
  //   label: '籍贯',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'ethnicity',
  //   label: '民族',
  // },
  {
    component: 'Input',
    fieldName: 'phoneNumber',
    label: '手机号码',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'emergencyContact',
  //   label: '紧急联系人',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'emergencyContactPhone',
  //   label: '紧急联系人电话',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'homeAddress',
  //   label: '家庭地址',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'householdRegistrationAddress',
  //   label: '户口所在地',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'workStartDate',
  //   label: '参加工作',
  // },
  {
    component: 'RangePicker',
    fieldName: 'entryDate',
    label: '入职时间',
    componentProps: {
      valueFormat: 'YYYY-MM-DD',
    },
  },
  // {
  //   component: 'Input',
  //   fieldName: 'yearsOfService',
  //   label: '工龄',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_YEARS_SERVICE_SEGMENT),
    },
    fieldName: 'yearsOfServiceSegment',
    label: '工龄段',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_MARITAL_STATUS),
    },
    fieldName: 'maritalStatus',
    label: '婚姻状况',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_POLITICAL_STATUS),
    },
    fieldName: 'politicalStatus',
    label: '政治面貌',
  },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_EDUCATION_CATEGORY),
    },
    fieldName: 'educationCategory',
    label: '学历分类',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'education',
  //   label: '学历',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'degree',
  //   label: '学位',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'graduationDate',
  //   label: '毕业时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'major',
  //   label: '专业',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'graduateSchool',
  //   label: '毕业院校',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'professionalTitle',
  //   label: '职称情况',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'resume',
  //   label: '简历',
  // },
  {
    component: 'Select',
    componentProps: {
      options: getDictOptions(HrDictEnum.HR_EMPLOYMENT_FORM),
    },
    fieldName: 'employmentForm',
    label: '用工形式',
  },
  // {
  //   component: 'Input',
  //   fieldName: 'contractTerm',
  //   label: '劳动合同期限',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'contractStartDate',
  //   label: '劳动合同开始时间',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'contractEndDate',
  //   label: '劳动合同截止时间',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'contractExpirationReminder',
  //   label: '合同到期提醒',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'contractEntity',
  //   label: '合同主体',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'regularizationDate',
  //   label: '转正时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'remarks',
  //   label: '备注',
  // },
  // {
  //   component: 'DatePicker',
  //   fieldName: 'resignationDate',
  //   label: '离职时间',
  // },
  // {
  //   component: 'Input',
  //   fieldName: 'resignationReason',
  //   label: '离职原因',
  // },
];

export function useColumns(): VxeTableGridOptions<EmployeeInfoApi.Employee>['columns'] {
  // onActionClick: OnActionClickFn<EmployeeInfoApi.Employee>,
  return [
    {
      title: '板块',
      field: 'plate',
    },
    {
      title: '一级部门',
      field: 'firstLevelDepartment',
    },
    {
      title: '二级部门',
      field: 'secondLevelDepartment',
    },
    {
      title: '三级部门',
      field: 'thirdLevelDepartment',
    },
    {
      title: '工号',
      field: 'employeeId',
    },
    // {
    //   title: '职级',
    //   field: 'jobLevel',
    // },
    {
      title: '主岗位',
      field: 'position',
    },
    {
      title: '序列',
      field: 'sequenceName',
    },
    {
      title: '姓名',
      field: 'name',
    },
    {
      title: '性别',
      field: 'genderName',
      // cellRender: {
      //   name: 'CellTag',
      //   options: [getTagDicts(HrDictEnum.HR_USER_SEX)],
      // },
    },
    // {
    //   title: '身份证号码',
    //   field: 'idCardNumber',
    // },
    // {
    //   title: '出生日期',
    //   field: 'birthDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '年龄',
    //   field: 'age',
    // },
    // {
    //   title: '年龄段',
    //   field: 'ageGroup',
    // },
    // {
    //   title: '籍贯',
    //   field: 'nativePlace',
    // },
    // {
    //   title: '民族',
    //   field: 'ethnicity',
    // },
    // {
    //   title: '婚姻状况',
    //   field: 'maritalStatus',
    // cellRender: { name: 'CellTag', options: [getTagDicts()] },
    // },
    // {
    //   title: '政治面貌',
    //   field: 'politicalStatus',
    // cellRender: { name: 'CellTag', options: [getTagDicts()] },
    // },
    {
      title: '手机号码',
      field: 'phoneNumber',
    },
    // {
    //   title: '紧急联系人',
    //   field: 'emergencyContact',
    // },
    // {
    //   title: '紧急联系人电话',
    //   field: 'emergencyContactPhone',
    // },
    // {
    //   title: '家庭地址',
    //   field: 'homeAddress',
    // },
    // {
    //   title: '户口所在地',
    //   field: 'householdRegistrationAddress',
    // },
    // {
    //   title: '参加工作时间',
    //   field: 'workStartDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '入职时间',
    //   field: 'entryDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '工龄',
    //   field: 'yearsOfService',
    // },
    // {
    //   title: '工龄段',
    //   field: 'yearsOfServiceSegment',
    // },
    {
      title: '学历',
      field: 'education',
    },
    // {
    //   title: '学位',
    //   field: 'degree',
    // },
    // {
    //   title: '毕业时间',
    //   field: 'graduationDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '专业',
    //   field: 'major',
    // },
    // {
    //   title: '毕业院校',
    //   field: 'graduateSchool',
    // },
    {
      title: '员工类型',
      field: 'employeeTypeName',
      // cellRender: {
      //   name: 'CellTag',
      //   options: [getTagDicts(HrDictEnum.HR_EMPLOYEE_TYPE)],
      // },
    },
    // {
    //   title: '职称情况',
    //   field: 'professionalTitle',
    // },
    // {
    //   title: '简历',
    //   field: 'resume',
    // },
    {
      title: '用工形式',
      field: 'employmentFormName',
      // cellRender: {
      //   name: 'CellTag',
      //   options: [getTagDicts(HrDictEnum.HR_EMPLOYMENT_FORM)],
      // },
    },
    {
      title: '劳动合同期限',
      field: 'contractTerm',
    },
    // {
    //   title: '劳动合同开始时间',
    //   field: 'contractStartDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '劳动合同截止时间',
    //   field: 'contractEndDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '合同到期提醒',
    //   field: 'contractExpirationReminder',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '劳动合同签订情况',
    //   field: 'contractSigningStatus',
    // cellRender: { name: 'CellTag', options: [getTagDicts()] },
    // },
    // {
    //   title: '合同主体',
    //   field: 'contractEntity',
    // },
    // {
    //   title: '转正时间',
    //   field: 'regularizationDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '异动情况',
    //   field: 'transferStatus',
    // cellRender: { name: 'CellTag', options: [getTagDicts()] },
    // },
    // {
    //   title: '奖惩情况',
    //   field: 'rewardPunishmentStatus',
    // cellRender: { name: 'CellTag', options: [getTagDicts()] },
    // },
    // {
    //   title: '备注',
    //   field: 'remarks',
    // },
    // {
    //   title: '离职时间',
    //   field: 'resignationDate',
    //   formatter: 'formatDateTime',
    // },
    // {
    //   title: '离职原因',
    //   field: 'resignationReason',
    // },
    {
      align: 'right',
      slots: { default: 'action' },
      // cellRender: {
      //   attrs: {
      //     nameField: 'name',
      //     nameTitle: '员工信息',
      //     onClick: onActionClick,
      //   },
      //   name: 'CellOperation',
      //   options: [
      //     {
      //       code: 'export',
      //       text: '导出简历',
      //       // disabled: (row: SysUserApi.User) => {
      //       //   return !!(row.id === 1);
      //       // },
      //       accessCode: ['employee:info:export'],
      //     },
      //     {
      //       code: 'edit',
      //       accessCode: ['employee:info:edit'],
      //     }, // 默认的编辑按钮
      //     {
      //       code: 'delete',
      //       text: '离职',
      //       accessCode: ['employee:info:remove'],
      //     }, // 默认的删除按钮
      //   ],
      // },
      field: 'action',
      fixed: 'right',
      headerAlign: 'center',
      resizable: false,
      showOverflow: false,
      title: '操作',
      width: 'auto',
    },
  ];
}
