import type { BaseModel, PageQuery } from '#/api/baseModel';

import { commonExport } from '#/api/helper';
import { requestClient } from '#/api/request';

export namespace LoginLogApi {
  export interface LoginLog extends BaseModel {
    /**
     * 用户名
     */
    userName: string;
    /**
     * 客户端密钥
     */
    clientKey: string;
    /**
     * 设备类型
     */
    deviceType?: string;
    /**
     * 登录状态
     */
    status: number;

    /**
     * 登录IP地址
     */
    ipaddr: string;
    /**
     * 登录地点
     */
    loginLocation?: string;
    /**
     * 浏览器类型
     */
    browser: string;
    /**
     * 操作系统
     */
    os: string;
    /**
     * 提示消息
     */
    msg?: string;
    /**
     * 访问时间
     */
    loginTime: string;
  }
}

/**
 * 查询系统登录日志列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/log/loginLog/page', { params });
}
/**
 * 查询系统登录日志详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/log/loginLog/${id}`);
}
// /**
//  * 新增系统登录日志
//  * @param data
//  */
// export function apiAdd(data: SysLoginLogApi.SysLoginLog) {
//   return requestClient.post('/log/sysLoginLog', data);
// }
// /**
//  * 修改系统登录日志
//  * @param data
//  */
// export function apiUpdate(data: SysLoginLogApi.SysLoginLog) {
//   return requestClient.put('/log/sysLoginLog', data);
// }
// /**
//  * 删除系统登录日志
//  * @param id
//  */
// export function apiDelete(id: Array<number> | number) {
//   return requestClient.delete(`/log/sysLoginLog/${id}`);
// }
/**
 * 导出系统登录日志
 * @param params
 */
export function apiExport(params: PageQuery) {
  return commonExport('/system/log/loginLog/export', params);
}
