import type { BaseModel, PageQuery } from '#/api/baseModel';

import { requestClient } from '#/api/request';

export namespace SysConfigApi {
  export interface Config extends BaseModel {
    /**
     * 参数名称
     */
    configName?: string;
    /**
     * 参数键名
     */
    configKey?: string;
    /**
     * 参数键值
     */
    configValue?: string;
    /**
     * 备注
     */
    remark?: string;
  }
}

/**
 * 查询参数配置列表
 * @param params
 * @returns {*} page
 */
export function apiPage(params: PageQuery) {
  return requestClient.get('/system/config/page', { params });
}
/**
 * 查询参数配置详细
 * @param id
 */
export function apiDetail(id: number) {
  return requestClient.get(`/system/config/${id}`);
}
/**
 * 新增参数配置
 * @param data
 */
export function apiAdd(data: SysConfigApi.Config) {
  return requestClient.post('/system/config', data);
}
/**
 * 修改参数配置
 * @param data
 */
export function apiUpdate(data: SysConfigApi.Config) {
  return requestClient.put('/system/config', data);
}
/**
 * 删除参数配置
 * @param id
 */
export function apiDelete(id: Array<number> | number) {
  return requestClient.delete(`/system/config/${id}`);
}
/**
 * 导出参数配置
 * @param params
 */
export function apiExport(params: PageQuery) {
  return requestClient.post('/system/config/export', params);
}
/**
 * 获取配置信息
 * @param configKey configKey
 * @returns value
 */
export function configInfoByKey(configKey: string) {
  return requestClient.get<string>(`/system/config/configKey/${configKey}`);
}
